/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.assistant.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;

public class ListEntitiesOptions
extends GenericModel {
    protected String workspaceId;
    protected Boolean export;
    protected Long pageLimit;
    protected Boolean includeCount;
    protected String sort;
    protected String cursor;
    protected Boolean includeAudit;

    protected ListEntitiesOptions(Builder builder) {
        Validator.notEmpty((String)builder.workspaceId, (String)"workspaceId cannot be empty");
        this.workspaceId = builder.workspaceId;
        this.export = builder.export;
        this.pageLimit = builder.pageLimit;
        this.includeCount = builder.includeCount;
        this.sort = builder.sort;
        this.cursor = builder.cursor;
        this.includeAudit = builder.includeAudit;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String workspaceId() {
        return this.workspaceId;
    }

    public Boolean export() {
        return this.export;
    }

    public Long pageLimit() {
        return this.pageLimit;
    }

    public Boolean includeCount() {
        return this.includeCount;
    }

    public String sort() {
        return this.sort;
    }

    public String cursor() {
        return this.cursor;
    }

    public Boolean includeAudit() {
        return this.includeAudit;
    }

    public static class Builder {
        private String workspaceId;
        private Boolean export;
        private Long pageLimit;
        private Boolean includeCount;
        private String sort;
        private String cursor;
        private Boolean includeAudit;

        private Builder(ListEntitiesOptions listEntitiesOptions) {
            this.workspaceId = listEntitiesOptions.workspaceId;
            this.export = listEntitiesOptions.export;
            this.pageLimit = listEntitiesOptions.pageLimit;
            this.includeCount = listEntitiesOptions.includeCount;
            this.sort = listEntitiesOptions.sort;
            this.cursor = listEntitiesOptions.cursor;
            this.includeAudit = listEntitiesOptions.includeAudit;
        }

        public Builder() {
        }

        public Builder(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        public ListEntitiesOptions build() {
            return new ListEntitiesOptions(this);
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder export(Boolean export) {
            this.export = export;
            return this;
        }

        public Builder pageLimit(long pageLimit) {
            this.pageLimit = pageLimit;
            return this;
        }

        public Builder includeCount(Boolean includeCount) {
            this.includeCount = includeCount;
            return this;
        }

        public Builder sort(String sort) {
            this.sort = sort;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder includeAudit(Boolean includeAudit) {
            this.includeAudit = includeAudit;
            return this;
        }
    }

    public static interface Sort {
        public static final String ENTITY = "entity";
        public static final String UPDATED = "updated";
    }
}

