/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.assistant.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;

public class ListLogsOptions
extends GenericModel {
    protected String workspaceId;
    protected String sort;
    protected String filter;
    protected Long pageLimit;
    protected String cursor;

    protected ListLogsOptions(Builder builder) {
        Validator.notEmpty((String)builder.workspaceId, (String)"workspaceId cannot be empty");
        this.workspaceId = builder.workspaceId;
        this.sort = builder.sort;
        this.filter = builder.filter;
        this.pageLimit = builder.pageLimit;
        this.cursor = builder.cursor;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String workspaceId() {
        return this.workspaceId;
    }

    public String sort() {
        return this.sort;
    }

    public String filter() {
        return this.filter;
    }

    public Long pageLimit() {
        return this.pageLimit;
    }

    public String cursor() {
        return this.cursor;
    }

    public static class Builder {
        private String workspaceId;
        private String sort;
        private String filter;
        private Long pageLimit;
        private String cursor;

        private Builder(ListLogsOptions listLogsOptions) {
            this.workspaceId = listLogsOptions.workspaceId;
            this.sort = listLogsOptions.sort;
            this.filter = listLogsOptions.filter;
            this.pageLimit = listLogsOptions.pageLimit;
            this.cursor = listLogsOptions.cursor;
        }

        public Builder() {
        }

        public Builder(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        public ListLogsOptions build() {
            return new ListLogsOptions(this);
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder sort(String sort) {
            this.sort = sort;
            return this;
        }

        public Builder filter(String filter) {
            this.filter = filter;
            return this;
        }

        public Builder pageLimit(long pageLimit) {
            this.pageLimit = pageLimit;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }
    }
}

