/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.assistant.v2;

import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.ibm.cloud.sdk.core.http.RequestBuilder;
import com.ibm.cloud.sdk.core.http.ResponseConverter;
import com.ibm.cloud.sdk.core.http.ServiceCall;
import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.security.ConfigBasedAuthenticatorFactory;
import com.ibm.cloud.sdk.core.service.BaseService;
import com.ibm.cloud.sdk.core.util.GsonSingleton;
import com.ibm.cloud.sdk.core.util.ResponseConverterUtils;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.assistant.v2.model.BulkClassifyOptions;
import com.ibm.watson.assistant.v2.model.BulkClassifyResponse;
import com.ibm.watson.assistant.v2.model.CreateSessionOptions;
import com.ibm.watson.assistant.v2.model.DeleteSessionOptions;
import com.ibm.watson.assistant.v2.model.DeleteUserDataOptions;
import com.ibm.watson.assistant.v2.model.ListLogsOptions;
import com.ibm.watson.assistant.v2.model.LogCollection;
import com.ibm.watson.assistant.v2.model.MessageOptions;
import com.ibm.watson.assistant.v2.model.MessageResponse;
import com.ibm.watson.assistant.v2.model.MessageResponseStateless;
import com.ibm.watson.assistant.v2.model.MessageStatelessOptions;
import com.ibm.watson.assistant.v2.model.SessionResponse;
import com.ibm.watson.common.SdkCommon;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import okhttp3.HttpUrl;

public class Assistant
extends BaseService {
    public static final String DEFAULT_SERVICE_NAME = "assistant";
    public static final String DEFAULT_SERVICE_URL = "https://api.us-south.assistant.watson.cloud.ibm.com";
    private String version;

    public Assistant(String version) {
        this(version, DEFAULT_SERVICE_NAME, ConfigBasedAuthenticatorFactory.getAuthenticator((String)DEFAULT_SERVICE_NAME));
    }

    public Assistant(String version, Authenticator authenticator) {
        this(version, DEFAULT_SERVICE_NAME, authenticator);
    }

    public Assistant(String version, String serviceName) {
        this(version, serviceName, ConfigBasedAuthenticatorFactory.getAuthenticator((String)serviceName));
    }

    public Assistant(String version, String serviceName, Authenticator authenticator) {
        super(serviceName, authenticator);
        this.setServiceUrl(DEFAULT_SERVICE_URL);
        this.setVersion(version);
        this.configureService(serviceName);
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        Validator.notEmpty((String)version, (String)"version cannot be empty.");
        this.version = version;
    }

    public ServiceCall<SessionResponse> createSession(CreateSessionOptions createSessionOptions) {
        Validator.notNull((Object)((Object)createSessionOptions), (String)"createSessionOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("assistant_id", createSessionOptions.assistantId());
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/assistants/{assistant_id}/sessions", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v2", (String)"createSession");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<SessionResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteSession(DeleteSessionOptions deleteSessionOptions) {
        Validator.notNull((Object)((Object)deleteSessionOptions), (String)"deleteSessionOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("assistant_id", deleteSessionOptions.assistantId());
        pathParamsMap.put("session_id", deleteSessionOptions.sessionId());
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/assistants/{assistant_id}/sessions/{session_id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v2", (String)"deleteSession");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<MessageResponse> message(MessageOptions messageOptions) {
        Validator.notNull((Object)((Object)messageOptions), (String)"messageOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("assistant_id", messageOptions.assistantId());
        pathParamsMap.put("session_id", messageOptions.sessionId());
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/assistants/{assistant_id}/sessions/{session_id}/message", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v2", (String)"message");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        JsonObject contentJson = new JsonObject();
        if (messageOptions.input() != null) {
            contentJson.add("input", GsonSingleton.getGson().toJsonTree((Object)messageOptions.input()));
        }
        if (messageOptions.context() != null) {
            contentJson.add("context", GsonSingleton.getGson().toJsonTree((Object)messageOptions.context()));
        }
        if (messageOptions.userId() != null) {
            contentJson.addProperty("user_id", messageOptions.userId());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<MessageResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<MessageResponseStateless> messageStateless(MessageStatelessOptions messageStatelessOptions) {
        Validator.notNull((Object)((Object)messageStatelessOptions), (String)"messageStatelessOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("assistant_id", messageStatelessOptions.assistantId());
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/assistants/{assistant_id}/message", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v2", (String)"messageStateless");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        JsonObject contentJson = new JsonObject();
        if (messageStatelessOptions.input() != null) {
            contentJson.add("input", GsonSingleton.getGson().toJsonTree((Object)messageStatelessOptions.input()));
        }
        if (messageStatelessOptions.context() != null) {
            contentJson.add("context", GsonSingleton.getGson().toJsonTree((Object)messageStatelessOptions.context()));
        }
        if (messageStatelessOptions.userId() != null) {
            contentJson.addProperty("user_id", messageStatelessOptions.userId());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<MessageResponseStateless>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<BulkClassifyResponse> bulkClassify(BulkClassifyOptions bulkClassifyOptions) {
        Validator.notNull((Object)((Object)bulkClassifyOptions), (String)"bulkClassifyOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("skill_id", bulkClassifyOptions.skillId());
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/skills/{skill_id}/workspace/bulk_classify", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v2", (String)"bulkClassify");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        JsonObject contentJson = new JsonObject();
        if (bulkClassifyOptions.input() != null) {
            contentJson.add("input", GsonSingleton.getGson().toJsonTree(bulkClassifyOptions.input()));
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<BulkClassifyResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<LogCollection> listLogs(ListLogsOptions listLogsOptions) {
        Validator.notNull((Object)((Object)listLogsOptions), (String)"listLogsOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("assistant_id", listLogsOptions.assistantId());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/assistants/{assistant_id}/logs", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v2", (String)"listLogs");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        if (listLogsOptions.sort() != null) {
            builder.query(new Object[]{"sort", String.valueOf(listLogsOptions.sort())});
        }
        if (listLogsOptions.filter() != null) {
            builder.query(new Object[]{"filter", String.valueOf(listLogsOptions.filter())});
        }
        if (listLogsOptions.pageLimit() != null) {
            builder.query(new Object[]{"page_limit", String.valueOf(listLogsOptions.pageLimit())});
        }
        if (listLogsOptions.cursor() != null) {
            builder.query(new Object[]{"cursor", String.valueOf(listLogsOptions.cursor())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<LogCollection>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteUserData(DeleteUserDataOptions deleteUserDataOptions) {
        Validator.notNull((Object)((Object)deleteUserDataOptions), (String)"deleteUserDataOptions cannot be null");
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/user_data"));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v2", (String)"deleteUserData");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        builder.query(new Object[]{"customer_id", String.valueOf(deleteUserDataOptions.customerId())});
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }
}

