/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.assistant.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.assistant.v1.model.Example;
import java.util.ArrayList;
import java.util.List;

public class CreateIntentOptions
extends GenericModel {
    protected String workspaceId;
    protected String intent;
    protected String description;
    protected List<Example> examples;
    protected Boolean includeAudit;

    protected CreateIntentOptions(Builder builder) {
        Validator.notEmpty((String)builder.workspaceId, (String)"workspaceId cannot be empty");
        Validator.notNull((Object)builder.intent, (String)"intent cannot be null");
        this.workspaceId = builder.workspaceId;
        this.intent = builder.intent;
        this.description = builder.description;
        this.examples = builder.examples;
        this.includeAudit = builder.includeAudit;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String workspaceId() {
        return this.workspaceId;
    }

    public String intent() {
        return this.intent;
    }

    public String description() {
        return this.description;
    }

    public List<Example> examples() {
        return this.examples;
    }

    public Boolean includeAudit() {
        return this.includeAudit;
    }

    public static class Builder {
        private String workspaceId;
        private String intent;
        private String description;
        private List<Example> examples;
        private Boolean includeAudit;

        private Builder(CreateIntentOptions createIntentOptions) {
            this.workspaceId = createIntentOptions.workspaceId;
            this.intent = createIntentOptions.intent;
            this.description = createIntentOptions.description;
            this.examples = createIntentOptions.examples;
            this.includeAudit = createIntentOptions.includeAudit;
        }

        public Builder() {
        }

        public Builder(String workspaceId, String intent) {
            this.workspaceId = workspaceId;
            this.intent = intent;
        }

        public CreateIntentOptions build() {
            return new CreateIntentOptions(this);
        }

        public Builder addExample(Example example) {
            Validator.notNull((Object)((Object)example), (String)"example cannot be null");
            if (this.examples == null) {
                this.examples = new ArrayList<Example>();
            }
            this.examples.add(example);
            return this;
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder intent(String intent) {
            this.intent = intent;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder examples(List<Example> examples) {
            this.examples = examples;
            return this;
        }

        public Builder includeAudit(Boolean includeAudit) {
            this.includeAudit = includeAudit;
            return this;
        }
    }
}

