/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.assistant.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.assistant.v1.model.LogMessageSource;

public class LogMessage
extends GenericModel {
    protected String level;
    protected String msg;
    protected String code;
    protected LogMessageSource source;

    protected LogMessage(Builder builder) {
        Validator.notNull((Object)builder.level, (String)"level cannot be null");
        Validator.notNull((Object)builder.msg, (String)"msg cannot be null");
        Validator.notNull((Object)builder.code, (String)"code cannot be null");
        this.level = builder.level;
        this.msg = builder.msg;
        this.code = builder.code;
        this.source = builder.source;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String level() {
        return this.level;
    }

    public String msg() {
        return this.msg;
    }

    public String code() {
        return this.code;
    }

    public LogMessageSource source() {
        return this.source;
    }

    public static class Builder {
        private String level;
        private String msg;
        private String code;
        private LogMessageSource source;

        private Builder(LogMessage logMessage) {
            this.level = logMessage.level;
            this.msg = logMessage.msg;
            this.code = logMessage.code;
            this.source = logMessage.source;
        }

        public Builder() {
        }

        public Builder(String level, String msg, String code) {
            this.level = level;
            this.msg = msg;
            this.code = code;
        }

        public LogMessage build() {
            return new LogMessage(this);
        }

        public Builder level(String level) {
            this.level = level;
            return this;
        }

        public Builder msg(String msg) {
            this.msg = msg;
            return this;
        }

        public Builder code(String code) {
            this.code = code;
            return this;
        }

        public Builder source(LogMessageSource source) {
            this.source = source;
            return this;
        }
    }

    public static interface Level {
        public static final String INFO = "info";
        public static final String ERROR = "error";
        public static final String WARN = "warn";
    }
}

