/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.assistant.v2.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.assistant.v2.model.CaptureGroup;
import com.ibm.watson.assistant.v2.model.RuntimeEntityAlternative;
import com.ibm.watson.assistant.v2.model.RuntimeEntityInterpretation;
import com.ibm.watson.assistant.v2.model.RuntimeEntityRole;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RuntimeEntity
extends GenericModel {
    protected String entity;
    protected List<Long> location;
    protected String value;
    protected Double confidence;
    protected Map<String, Object> metadata;
    protected List<CaptureGroup> groups;
    protected RuntimeEntityInterpretation interpretation;
    protected List<RuntimeEntityAlternative> alternatives;
    protected RuntimeEntityRole role;

    protected RuntimeEntity(Builder builder) {
        Validator.notNull((Object)builder.entity, (String)"entity cannot be null");
        Validator.notNull((Object)builder.value, (String)"value cannot be null");
        this.entity = builder.entity;
        this.location = builder.location;
        this.value = builder.value;
        this.confidence = builder.confidence;
        this.metadata = builder.metadata;
        this.groups = builder.groups;
        this.interpretation = builder.interpretation;
        this.alternatives = builder.alternatives;
        this.role = builder.role;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String entity() {
        return this.entity;
    }

    public List<Long> location() {
        return this.location;
    }

    public String value() {
        return this.value;
    }

    public Double confidence() {
        return this.confidence;
    }

    public Map<String, Object> metadata() {
        return this.metadata;
    }

    public List<CaptureGroup> groups() {
        return this.groups;
    }

    public RuntimeEntityInterpretation interpretation() {
        return this.interpretation;
    }

    public List<RuntimeEntityAlternative> alternatives() {
        return this.alternatives;
    }

    public RuntimeEntityRole role() {
        return this.role;
    }

    public static class Builder {
        private String entity;
        private List<Long> location;
        private String value;
        private Double confidence;
        private Map<String, Object> metadata;
        private List<CaptureGroup> groups;
        private RuntimeEntityInterpretation interpretation;
        private List<RuntimeEntityAlternative> alternatives;
        private RuntimeEntityRole role;

        private Builder(RuntimeEntity runtimeEntity) {
            this.entity = runtimeEntity.entity;
            this.location = runtimeEntity.location;
            this.value = runtimeEntity.value;
            this.confidence = runtimeEntity.confidence;
            this.metadata = runtimeEntity.metadata;
            this.groups = runtimeEntity.groups;
            this.interpretation = runtimeEntity.interpretation;
            this.alternatives = runtimeEntity.alternatives;
            this.role = runtimeEntity.role;
        }

        public Builder() {
        }

        public Builder(String entity, String value) {
            this.entity = entity;
            this.value = value;
        }

        public RuntimeEntity build() {
            return new RuntimeEntity(this);
        }

        public Builder addLocation(Long location) {
            Validator.notNull((Object)location, (String)"location cannot be null");
            if (this.location == null) {
                this.location = new ArrayList<Long>();
            }
            this.location.add(location);
            return this;
        }

        public Builder addGroups(CaptureGroup groups) {
            Validator.notNull((Object)((Object)groups), (String)"groups cannot be null");
            if (this.groups == null) {
                this.groups = new ArrayList<CaptureGroup>();
            }
            this.groups.add(groups);
            return this;
        }

        public Builder addAlternatives(RuntimeEntityAlternative alternatives) {
            Validator.notNull((Object)((Object)alternatives), (String)"alternatives cannot be null");
            if (this.alternatives == null) {
                this.alternatives = new ArrayList<RuntimeEntityAlternative>();
            }
            this.alternatives.add(alternatives);
            return this;
        }

        public Builder entity(String entity) {
            this.entity = entity;
            return this;
        }

        public Builder location(List<Long> location) {
            this.location = location;
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            return this;
        }

        public Builder confidence(Double confidence) {
            this.confidence = confidence;
            return this;
        }

        public Builder metadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder groups(List<CaptureGroup> groups) {
            this.groups = groups;
            return this;
        }

        public Builder interpretation(RuntimeEntityInterpretation interpretation) {
            this.interpretation = interpretation;
            return this;
        }

        public Builder alternatives(List<RuntimeEntityAlternative> alternatives) {
            this.alternatives = alternatives;
            return this;
        }

        public Builder role(RuntimeEntityRole role) {
            this.role = role;
            return this;
        }
    }
}

