/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.compare_comply.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.compare_comply.v1.model.Category;
import com.ibm.watson.compare_comply.v1.model.TypeLabel;
import java.util.ArrayList;
import java.util.List;

public class OriginalLabelsIn
extends GenericModel {
    private List<TypeLabel> types;
    private List<Category> categories;

    private OriginalLabelsIn(Builder builder) {
        Validator.notNull((Object)builder.types, (String)"types cannot be null");
        Validator.notNull((Object)builder.categories, (String)"categories cannot be null");
        this.types = builder.types;
        this.categories = builder.categories;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public List<TypeLabel> types() {
        return this.types;
    }

    public List<Category> categories() {
        return this.categories;
    }

    public static class Builder {
        private List<TypeLabel> types;
        private List<Category> categories;

        private Builder(OriginalLabelsIn originalLabelsIn) {
            this.types = originalLabelsIn.types;
            this.categories = originalLabelsIn.categories;
        }

        public Builder() {
        }

        public Builder(List<TypeLabel> types, List<Category> categories) {
            this.types = types;
            this.categories = categories;
        }

        public OriginalLabelsIn build() {
            return new OriginalLabelsIn(this);
        }

        public Builder addTypes(TypeLabel types) {
            Validator.notNull((Object)((Object)types), (String)"types cannot be null");
            if (this.types == null) {
                this.types = new ArrayList<TypeLabel>();
            }
            this.types.add(types);
            return this;
        }

        public Builder addCategories(Category categories) {
            Validator.notNull((Object)((Object)categories), (String)"categories cannot be null");
            if (this.categories == null) {
                this.categories = new ArrayList<Category>();
            }
            this.categories.add(categories);
            return this;
        }

        public Builder types(List<TypeLabel> types) {
            this.types = types;
            return this;
        }

        public Builder categories(List<Category> categories) {
            this.categories = categories;
            return this;
        }
    }
}

