/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.compare_comply.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;

public class UpdateBatchOptions
extends GenericModel {
    private String batchId;
    private String action;
    private String model;

    private UpdateBatchOptions(Builder builder) {
        Validator.notEmpty((String)builder.batchId, (String)"batchId cannot be empty");
        Validator.notNull((Object)builder.action, (String)"action cannot be null");
        this.batchId = builder.batchId;
        this.action = builder.action;
        this.model = builder.model;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String batchId() {
        return this.batchId;
    }

    public String action() {
        return this.action;
    }

    public String model() {
        return this.model;
    }

    public static class Builder {
        private String batchId;
        private String action;
        private String model;

        private Builder(UpdateBatchOptions updateBatchOptions) {
            this.batchId = updateBatchOptions.batchId;
            this.action = updateBatchOptions.action;
            this.model = updateBatchOptions.model;
        }

        public Builder() {
        }

        public Builder(String batchId, String action) {
            this.batchId = batchId;
            this.action = action;
        }

        public UpdateBatchOptions build() {
            return new UpdateBatchOptions(this);
        }

        public Builder batchId(String batchId) {
            this.batchId = batchId;
            return this;
        }

        public Builder action(String action) {
            this.action = action;
            return this;
        }

        public Builder model(String model) {
            this.model = model;
            return this;
        }
    }

    public static interface Model {
        public static final String CONTRACTS = "contracts";
        public static final String TABLES = "tables";
    }

    public static interface Action {
        public static final String RESCAN = "rescan";
        public static final String CANCEL = "cancel";
    }
}

