/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.compare_comply.v1;

import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.ibm.cloud.sdk.core.http.RequestBuilder;
import com.ibm.cloud.sdk.core.http.ResponseConverter;
import com.ibm.cloud.sdk.core.http.ServiceCall;
import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.security.ConfigBasedAuthenticatorFactory;
import com.ibm.cloud.sdk.core.service.BaseService;
import com.ibm.cloud.sdk.core.util.GsonSingleton;
import com.ibm.cloud.sdk.core.util.RequestUtils;
import com.ibm.cloud.sdk.core.util.ResponseConverterUtils;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.common.SdkCommon;
import com.ibm.watson.compare_comply.v1.model.AddFeedbackOptions;
import com.ibm.watson.compare_comply.v1.model.BatchStatus;
import com.ibm.watson.compare_comply.v1.model.Batches;
import com.ibm.watson.compare_comply.v1.model.ClassifyElementsOptions;
import com.ibm.watson.compare_comply.v1.model.ClassifyReturn;
import com.ibm.watson.compare_comply.v1.model.CompareDocumentsOptions;
import com.ibm.watson.compare_comply.v1.model.CompareReturn;
import com.ibm.watson.compare_comply.v1.model.ConvertToHtmlOptions;
import com.ibm.watson.compare_comply.v1.model.CreateBatchOptions;
import com.ibm.watson.compare_comply.v1.model.DeleteFeedbackOptions;
import com.ibm.watson.compare_comply.v1.model.ExtractTablesOptions;
import com.ibm.watson.compare_comply.v1.model.FeedbackDeleted;
import com.ibm.watson.compare_comply.v1.model.FeedbackList;
import com.ibm.watson.compare_comply.v1.model.FeedbackReturn;
import com.ibm.watson.compare_comply.v1.model.GetBatchOptions;
import com.ibm.watson.compare_comply.v1.model.GetFeedback;
import com.ibm.watson.compare_comply.v1.model.GetFeedbackOptions;
import com.ibm.watson.compare_comply.v1.model.HTMLReturn;
import com.ibm.watson.compare_comply.v1.model.ListBatchesOptions;
import com.ibm.watson.compare_comply.v1.model.ListFeedbackOptions;
import com.ibm.watson.compare_comply.v1.model.TableReturn;
import com.ibm.watson.compare_comply.v1.model.UpdateBatchOptions;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Map;
import okhttp3.HttpUrl;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;

public class CompareComply
extends BaseService {
    private static final String DEFAULT_SERVICE_NAME = "compare_comply";
    private static final String DEFAULT_SERVICE_URL = "https://gateway.watsonplatform.net/compare-comply/api";
    private String versionDate;

    public CompareComply(String versionDate) {
        this(versionDate, DEFAULT_SERVICE_NAME, ConfigBasedAuthenticatorFactory.getAuthenticator((String)DEFAULT_SERVICE_NAME));
    }

    public CompareComply(String versionDate, Authenticator authenticator) {
        this(versionDate, DEFAULT_SERVICE_NAME, authenticator);
    }

    public CompareComply(String versionDate, String serviceName) {
        this(versionDate, serviceName, ConfigBasedAuthenticatorFactory.getAuthenticator((String)serviceName));
    }

    public CompareComply(String versionDate, String serviceName, Authenticator authenticator) {
        super(serviceName, authenticator);
        this.setServiceUrl(DEFAULT_SERVICE_URL);
        Validator.isTrue((versionDate != null && !versionDate.isEmpty() ? 1 : 0) != 0, (String)"version cannot be null.");
        this.versionDate = versionDate;
        this.configureService(serviceName);
    }

    public ServiceCall<HTMLReturn> convertToHtml(ConvertToHtmlOptions convertToHtmlOptions) {
        Validator.notNull((Object)((Object)convertToHtmlOptions), (String)"convertToHtmlOptions cannot be null");
        String[] pathSegments = new String[]{"v1/html_conversion"};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"compare-comply", (String)"v1", (String)"convertToHtml");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (convertToHtmlOptions.model() != null) {
            builder.query(new Object[]{"model", convertToHtmlOptions.model()});
        }
        MultipartBody.Builder multipartBuilder = new MultipartBody.Builder();
        multipartBuilder.setType(MultipartBody.FORM);
        RequestBody fileBody = RequestUtils.inputStreamBody((InputStream)convertToHtmlOptions.file(), (String)convertToHtmlOptions.fileContentType());
        multipartBuilder.addFormDataPart("file", "filename", fileBody);
        builder.body((RequestBody)multipartBuilder.build());
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<HTMLReturn>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ClassifyReturn> classifyElements(ClassifyElementsOptions classifyElementsOptions) {
        Validator.notNull((Object)((Object)classifyElementsOptions), (String)"classifyElementsOptions cannot be null");
        String[] pathSegments = new String[]{"v1/element_classification"};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"compare-comply", (String)"v1", (String)"classifyElements");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (classifyElementsOptions.model() != null) {
            builder.query(new Object[]{"model", classifyElementsOptions.model()});
        }
        MultipartBody.Builder multipartBuilder = new MultipartBody.Builder();
        multipartBuilder.setType(MultipartBody.FORM);
        RequestBody fileBody = RequestUtils.inputStreamBody((InputStream)classifyElementsOptions.file(), (String)classifyElementsOptions.fileContentType());
        multipartBuilder.addFormDataPart("file", "filename", fileBody);
        builder.body((RequestBody)multipartBuilder.build());
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ClassifyReturn>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<TableReturn> extractTables(ExtractTablesOptions extractTablesOptions) {
        Validator.notNull((Object)((Object)extractTablesOptions), (String)"extractTablesOptions cannot be null");
        String[] pathSegments = new String[]{"v1/tables"};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"compare-comply", (String)"v1", (String)"extractTables");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (extractTablesOptions.model() != null) {
            builder.query(new Object[]{"model", extractTablesOptions.model()});
        }
        MultipartBody.Builder multipartBuilder = new MultipartBody.Builder();
        multipartBuilder.setType(MultipartBody.FORM);
        RequestBody fileBody = RequestUtils.inputStreamBody((InputStream)extractTablesOptions.file(), (String)extractTablesOptions.fileContentType());
        multipartBuilder.addFormDataPart("file", "filename", fileBody);
        builder.body((RequestBody)multipartBuilder.build());
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<TableReturn>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<CompareReturn> compareDocuments(CompareDocumentsOptions compareDocumentsOptions) {
        Validator.notNull((Object)((Object)compareDocumentsOptions), (String)"compareDocumentsOptions cannot be null");
        String[] pathSegments = new String[]{"v1/comparison"};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"compare-comply", (String)"v1", (String)"compareDocuments");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (compareDocumentsOptions.file1Label() != null) {
            builder.query(new Object[]{"file_1_label", compareDocumentsOptions.file1Label()});
        }
        if (compareDocumentsOptions.file2Label() != null) {
            builder.query(new Object[]{"file_2_label", compareDocumentsOptions.file2Label()});
        }
        if (compareDocumentsOptions.model() != null) {
            builder.query(new Object[]{"model", compareDocumentsOptions.model()});
        }
        MultipartBody.Builder multipartBuilder = new MultipartBody.Builder();
        multipartBuilder.setType(MultipartBody.FORM);
        RequestBody file1Body = RequestUtils.inputStreamBody((InputStream)compareDocumentsOptions.file1(), (String)compareDocumentsOptions.file1ContentType());
        multipartBuilder.addFormDataPart("file_1", "filename", file1Body);
        RequestBody file2Body = RequestUtils.inputStreamBody((InputStream)compareDocumentsOptions.file2(), (String)compareDocumentsOptions.file2ContentType());
        multipartBuilder.addFormDataPart("file_2", "filename", file2Body);
        builder.body((RequestBody)multipartBuilder.build());
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<CompareReturn>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<FeedbackReturn> addFeedback(AddFeedbackOptions addFeedbackOptions) {
        Validator.notNull((Object)((Object)addFeedbackOptions), (String)"addFeedbackOptions cannot be null");
        String[] pathSegments = new String[]{"v1/feedback"};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"compare-comply", (String)"v1", (String)"addFeedback");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        contentJson.add("feedback_data", GsonSingleton.getGson().toJsonTree((Object)addFeedbackOptions.feedbackData()));
        if (addFeedbackOptions.userId() != null) {
            contentJson.addProperty("user_id", addFeedbackOptions.userId());
        }
        if (addFeedbackOptions.comment() != null) {
            contentJson.addProperty("comment", addFeedbackOptions.comment());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<FeedbackReturn>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<FeedbackList> listFeedback(ListFeedbackOptions listFeedbackOptions) {
        String[] pathSegments = new String[]{"v1/feedback"};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"compare-comply", (String)"v1", (String)"listFeedback");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (listFeedbackOptions != null) {
            if (listFeedbackOptions.feedbackType() != null) {
                builder.query(new Object[]{"feedback_type", listFeedbackOptions.feedbackType()});
            }
            if (listFeedbackOptions.before() != null) {
                builder.query(new Object[]{"before", String.valueOf(listFeedbackOptions.before())});
            }
            if (listFeedbackOptions.after() != null) {
                builder.query(new Object[]{"after", String.valueOf(listFeedbackOptions.after())});
            }
            if (listFeedbackOptions.documentTitle() != null) {
                builder.query(new Object[]{"document_title", listFeedbackOptions.documentTitle()});
            }
            if (listFeedbackOptions.modelId() != null) {
                builder.query(new Object[]{"model_id", listFeedbackOptions.modelId()});
            }
            if (listFeedbackOptions.modelVersion() != null) {
                builder.query(new Object[]{"model_version", listFeedbackOptions.modelVersion()});
            }
            if (listFeedbackOptions.categoryRemoved() != null) {
                builder.query(new Object[]{"category_removed", listFeedbackOptions.categoryRemoved()});
            }
            if (listFeedbackOptions.categoryAdded() != null) {
                builder.query(new Object[]{"category_added", listFeedbackOptions.categoryAdded()});
            }
            if (listFeedbackOptions.categoryNotChanged() != null) {
                builder.query(new Object[]{"category_not_changed", listFeedbackOptions.categoryNotChanged()});
            }
            if (listFeedbackOptions.typeRemoved() != null) {
                builder.query(new Object[]{"type_removed", listFeedbackOptions.typeRemoved()});
            }
            if (listFeedbackOptions.typeAdded() != null) {
                builder.query(new Object[]{"type_added", listFeedbackOptions.typeAdded()});
            }
            if (listFeedbackOptions.typeNotChanged() != null) {
                builder.query(new Object[]{"type_not_changed", listFeedbackOptions.typeNotChanged()});
            }
            if (listFeedbackOptions.pageLimit() != null) {
                builder.query(new Object[]{"page_limit", String.valueOf(listFeedbackOptions.pageLimit())});
            }
            if (listFeedbackOptions.cursor() != null) {
                builder.query(new Object[]{"cursor", listFeedbackOptions.cursor()});
            }
            if (listFeedbackOptions.sort() != null) {
                builder.query(new Object[]{"sort", listFeedbackOptions.sort()});
            }
            if (listFeedbackOptions.includeTotal() != null) {
                builder.query(new Object[]{"include_total", String.valueOf(listFeedbackOptions.includeTotal())});
            }
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<FeedbackList>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<FeedbackList> listFeedback() {
        return this.listFeedback(null);
    }

    public ServiceCall<GetFeedback> getFeedback(GetFeedbackOptions getFeedbackOptions) {
        Validator.notNull((Object)((Object)getFeedbackOptions), (String)"getFeedbackOptions cannot be null");
        String[] pathSegments = new String[]{"v1/feedback"};
        String[] pathParameters = new String[]{getFeedbackOptions.feedbackId()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"compare-comply", (String)"v1", (String)"getFeedback");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (getFeedbackOptions.model() != null) {
            builder.query(new Object[]{"model", getFeedbackOptions.model()});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<GetFeedback>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<FeedbackDeleted> deleteFeedback(DeleteFeedbackOptions deleteFeedbackOptions) {
        Validator.notNull((Object)((Object)deleteFeedbackOptions), (String)"deleteFeedbackOptions cannot be null");
        String[] pathSegments = new String[]{"v1/feedback"};
        String[] pathParameters = new String[]{deleteFeedbackOptions.feedbackId()};
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"compare-comply", (String)"v1", (String)"deleteFeedback");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (deleteFeedbackOptions.model() != null) {
            builder.query(new Object[]{"model", deleteFeedbackOptions.model()});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<FeedbackDeleted>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<BatchStatus> createBatch(CreateBatchOptions createBatchOptions) {
        Validator.notNull((Object)((Object)createBatchOptions), (String)"createBatchOptions cannot be null");
        String[] pathSegments = new String[]{"v1/batches"};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"compare-comply", (String)"v1", (String)"createBatch");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"function", createBatchOptions.function()});
        if (createBatchOptions.model() != null) {
            builder.query(new Object[]{"model", createBatchOptions.model()});
        }
        MultipartBody.Builder multipartBuilder = new MultipartBody.Builder();
        multipartBuilder.setType(MultipartBody.FORM);
        RequestBody inputCredentialsFileBody = RequestUtils.inputStreamBody((InputStream)createBatchOptions.inputCredentialsFile(), (String)"application/json");
        multipartBuilder.addFormDataPart("input_credentials_file", "filename", inputCredentialsFileBody);
        multipartBuilder.addFormDataPart("input_bucket_location", createBatchOptions.inputBucketLocation());
        multipartBuilder.addFormDataPart("input_bucket_name", createBatchOptions.inputBucketName());
        RequestBody outputCredentialsFileBody = RequestUtils.inputStreamBody((InputStream)createBatchOptions.outputCredentialsFile(), (String)"application/json");
        multipartBuilder.addFormDataPart("output_credentials_file", "filename", outputCredentialsFileBody);
        multipartBuilder.addFormDataPart("output_bucket_location", createBatchOptions.outputBucketLocation());
        multipartBuilder.addFormDataPart("output_bucket_name", createBatchOptions.outputBucketName());
        builder.body((RequestBody)multipartBuilder.build());
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<BatchStatus>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Batches> listBatches(ListBatchesOptions listBatchesOptions) {
        String[] pathSegments = new String[]{"v1/batches"};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"compare-comply", (String)"v1", (String)"listBatches");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (listBatchesOptions != null) {
            // empty if block
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Batches>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Batches> listBatches() {
        return this.listBatches(null);
    }

    public ServiceCall<BatchStatus> getBatch(GetBatchOptions getBatchOptions) {
        Validator.notNull((Object)((Object)getBatchOptions), (String)"getBatchOptions cannot be null");
        String[] pathSegments = new String[]{"v1/batches"};
        String[] pathParameters = new String[]{getBatchOptions.batchId()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"compare-comply", (String)"v1", (String)"getBatch");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<BatchStatus>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<BatchStatus> updateBatch(UpdateBatchOptions updateBatchOptions) {
        Validator.notNull((Object)((Object)updateBatchOptions), (String)"updateBatchOptions cannot be null");
        String[] pathSegments = new String[]{"v1/batches"};
        String[] pathParameters = new String[]{updateBatchOptions.batchId()};
        RequestBuilder builder = RequestBuilder.put((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"compare-comply", (String)"v1", (String)"updateBatch");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"action", updateBatchOptions.action()});
        if (updateBatchOptions.model() != null) {
            builder.query(new Object[]{"model", updateBatchOptions.model()});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<BatchStatus>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }
}

