/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.compare_comply.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class CreateBatchOptions
extends GenericModel {
    protected String function;
    protected InputStream inputCredentialsFile;
    protected String inputBucketLocation;
    protected String inputBucketName;
    protected InputStream outputCredentialsFile;
    protected String outputBucketLocation;
    protected String outputBucketName;
    protected String model;

    protected CreateBatchOptions(Builder builder) {
        Validator.notNull((Object)builder.function, (String)"function cannot be null");
        Validator.notNull((Object)builder.inputCredentialsFile, (String)"inputCredentialsFile cannot be null");
        Validator.notNull((Object)builder.inputBucketLocation, (String)"inputBucketLocation cannot be null");
        Validator.notNull((Object)builder.inputBucketName, (String)"inputBucketName cannot be null");
        Validator.notNull((Object)builder.outputCredentialsFile, (String)"outputCredentialsFile cannot be null");
        Validator.notNull((Object)builder.outputBucketLocation, (String)"outputBucketLocation cannot be null");
        Validator.notNull((Object)builder.outputBucketName, (String)"outputBucketName cannot be null");
        this.function = builder.function;
        this.inputCredentialsFile = builder.inputCredentialsFile;
        this.inputBucketLocation = builder.inputBucketLocation;
        this.inputBucketName = builder.inputBucketName;
        this.outputCredentialsFile = builder.outputCredentialsFile;
        this.outputBucketLocation = builder.outputBucketLocation;
        this.outputBucketName = builder.outputBucketName;
        this.model = builder.model;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String function() {
        return this.function;
    }

    public InputStream inputCredentialsFile() {
        return this.inputCredentialsFile;
    }

    public String inputBucketLocation() {
        return this.inputBucketLocation;
    }

    public String inputBucketName() {
        return this.inputBucketName;
    }

    public InputStream outputCredentialsFile() {
        return this.outputCredentialsFile;
    }

    public String outputBucketLocation() {
        return this.outputBucketLocation;
    }

    public String outputBucketName() {
        return this.outputBucketName;
    }

    public String model() {
        return this.model;
    }

    public static class Builder {
        private String function;
        private InputStream inputCredentialsFile;
        private String inputBucketLocation;
        private String inputBucketName;
        private InputStream outputCredentialsFile;
        private String outputBucketLocation;
        private String outputBucketName;
        private String model;

        private Builder(CreateBatchOptions createBatchOptions) {
            this.function = createBatchOptions.function;
            this.inputCredentialsFile = createBatchOptions.inputCredentialsFile;
            this.inputBucketLocation = createBatchOptions.inputBucketLocation;
            this.inputBucketName = createBatchOptions.inputBucketName;
            this.outputCredentialsFile = createBatchOptions.outputCredentialsFile;
            this.outputBucketLocation = createBatchOptions.outputBucketLocation;
            this.outputBucketName = createBatchOptions.outputBucketName;
            this.model = createBatchOptions.model;
        }

        public Builder() {
        }

        public Builder(String function, InputStream inputCredentialsFile, String inputBucketLocation, String inputBucketName, InputStream outputCredentialsFile, String outputBucketLocation, String outputBucketName) {
            this.function = function;
            this.inputCredentialsFile = inputCredentialsFile;
            this.inputBucketLocation = inputBucketLocation;
            this.inputBucketName = inputBucketName;
            this.outputCredentialsFile = outputCredentialsFile;
            this.outputBucketLocation = outputBucketLocation;
            this.outputBucketName = outputBucketName;
        }

        public CreateBatchOptions build() {
            return new CreateBatchOptions(this);
        }

        public Builder function(String function) {
            this.function = function;
            return this;
        }

        public Builder inputCredentialsFile(InputStream inputCredentialsFile) {
            this.inputCredentialsFile = inputCredentialsFile;
            return this;
        }

        public Builder inputBucketLocation(String inputBucketLocation) {
            this.inputBucketLocation = inputBucketLocation;
            return this;
        }

        public Builder inputBucketName(String inputBucketName) {
            this.inputBucketName = inputBucketName;
            return this;
        }

        public Builder outputCredentialsFile(InputStream outputCredentialsFile) {
            this.outputCredentialsFile = outputCredentialsFile;
            return this;
        }

        public Builder outputBucketLocation(String outputBucketLocation) {
            this.outputBucketLocation = outputBucketLocation;
            return this;
        }

        public Builder outputBucketName(String outputBucketName) {
            this.outputBucketName = outputBucketName;
            return this;
        }

        public Builder model(String model) {
            this.model = model;
            return this;
        }

        public Builder inputCredentialsFile(File inputCredentialsFile) throws FileNotFoundException {
            this.inputCredentialsFile = new FileInputStream(inputCredentialsFile);
            return this;
        }

        public Builder outputCredentialsFile(File outputCredentialsFile) throws FileNotFoundException {
            this.outputCredentialsFile = new FileInputStream(outputCredentialsFile);
            return this;
        }
    }

    public static interface Model {
        public static final String CONTRACTS = "contracts";
        public static final String TABLES = "tables";
    }

    public static interface Function {
        public static final String HTML_CONVERSION = "html_conversion";
        public static final String ELEMENT_CLASSIFICATION = "element_classification";
        public static final String TABLES = "tables";
    }
}

