/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.compare_comply.v1.model;

import com.google.gson.annotations.SerializedName;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.compare_comply.v1.model.Label;
import java.util.ArrayList;
import java.util.List;

public class TypeLabel
extends GenericModel {
    protected Label label;
    @SerializedName(value="provenance_ids")
    protected List<String> provenanceIds;

    protected TypeLabel(Builder builder) {
        this.label = builder.label;
        this.provenanceIds = builder.provenanceIds;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public Label label() {
        return this.label;
    }

    public List<String> provenanceIds() {
        return this.provenanceIds;
    }

    public static class Builder {
        private Label label;
        private List<String> provenanceIds;

        private Builder(TypeLabel typeLabel) {
            this.label = typeLabel.label;
            this.provenanceIds = typeLabel.provenanceIds;
        }

        public Builder() {
        }

        public TypeLabel build() {
            return new TypeLabel(this);
        }

        public Builder addProvenanceIds(String provenanceIds) {
            Validator.notNull((Object)provenanceIds, (String)"provenanceIds cannot be null");
            if (this.provenanceIds == null) {
                this.provenanceIds = new ArrayList<String>();
            }
            this.provenanceIds.add(provenanceIds);
            return this;
        }

        public Builder label(Label label) {
            this.label = label;
            return this;
        }

        public Builder provenanceIds(List<String> provenanceIds) {
            this.provenanceIds = provenanceIds;
            return this;
        }
    }
}

