/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.compare_comply.v1.model;

import com.google.gson.annotations.SerializedName;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class Category
extends GenericModel {
    protected String label;
    @SerializedName(value="provenance_ids")
    protected List<String> provenanceIds;
    protected String modification;

    protected Category(Builder builder) {
        this.label = builder.label;
        this.provenanceIds = builder.provenanceIds;
        this.modification = builder.modification;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String label() {
        return this.label;
    }

    public List<String> provenanceIds() {
        return this.provenanceIds;
    }

    public String modification() {
        return this.modification;
    }

    public static class Builder {
        private String label;
        private List<String> provenanceIds;
        private String modification;

        private Builder(Category category) {
            this.label = category.label;
            this.provenanceIds = category.provenanceIds;
            this.modification = category.modification;
        }

        public Builder() {
        }

        public Category build() {
            return new Category(this);
        }

        public Builder addProvenanceIds(String provenanceIds) {
            Validator.notNull((Object)provenanceIds, (String)"provenanceIds cannot be null");
            if (this.provenanceIds == null) {
                this.provenanceIds = new ArrayList<String>();
            }
            this.provenanceIds.add(provenanceIds);
            return this;
        }

        public Builder label(String label) {
            this.label = label;
            return this;
        }

        public Builder provenanceIds(List<String> provenanceIds) {
            this.provenanceIds = provenanceIds;
            return this;
        }

        public Builder modification(String modification) {
            this.modification = modification;
            return this;
        }
    }

    public static interface Modification {
        public static final String ADDED = "added";
        public static final String UNCHANGED = "unchanged";
        public static final String REMOVED = "removed";
    }

    public static interface Label {
        public static final String AMENDMENTS = "Amendments";
        public static final String ASSET_USE = "Asset Use";
        public static final String ASSIGNMENTS = "Assignments";
        public static final String AUDITS = "Audits";
        public static final String BUSINESS_CONTINUITY = "Business Continuity";
        public static final String COMMUNICATION = "Communication";
        public static final String CONFIDENTIALITY = "Confidentiality";
        public static final String DELIVERABLES = "Deliverables";
        public static final String DELIVERY = "Delivery";
        public static final String DISPUTE_RESOLUTION = "Dispute Resolution";
        public static final String FORCE_MAJEURE = "Force Majeure";
        public static final String INDEMNIFICATION = "Indemnification";
        public static final String INSURANCE = "Insurance";
        public static final String INTELLECTUAL_PROPERTY = "Intellectual Property";
        public static final String LIABILITY = "Liability";
        public static final String ORDER_OF_PRECEDENCE = "Order of Precedence";
        public static final String PAYMENT_TERMS_BILLING = "Payment Terms & Billing";
        public static final String PRICING_TAXES = "Pricing & Taxes";
        public static final String PRIVACY = "Privacy";
        public static final String RESPONSIBILITIES = "Responsibilities";
        public static final String SAFETY_AND_SECURITY = "Safety and Security";
        public static final String SCOPE_OF_WORK = "Scope of Work";
        public static final String SUBCONTRACTS = "Subcontracts";
        public static final String TERM_TERMINATION = "Term & Termination";
        public static final String WARRANTIES = "Warranties";
    }
}

