/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.natural_language_classifier.v1;

import com.google.gson.JsonObject;
import com.ibm.watson.developer_cloud.http.HttpMediaType;
import com.ibm.watson.developer_cloud.http.RequestBuilder;
import com.ibm.watson.developer_cloud.http.ServiceCall;
import com.ibm.watson.developer_cloud.natural_language_classifier.v1.model.Classification;
import com.ibm.watson.developer_cloud.natural_language_classifier.v1.model.Classifier;
import com.ibm.watson.developer_cloud.natural_language_classifier.v1.model.Classifiers;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.util.ResponseConverterUtils;
import com.ibm.watson.developer_cloud.util.Validator;
import java.io.File;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;

public class NaturalLanguageClassifier
extends WatsonService {
    private static final String SERVICE_NAME = "natural_language_classifier";
    private static final String FORM_DATA_TRAINING_DATA = "form-data; name=\"training_data\"";
    private static final String PATH_CLASSIFIERS = "/v1/classifiers";
    private static final String TEXT = "text";
    private static final String PATH_CLASSIFY = "/v1/classifiers/%s/classify";
    private static final String LANGUAGE = "language";
    private static final String NAME = "name";
    private static final String TRAINING_METADATA = "training_metadata";
    private static final String PATH_CLASSIFIER = "/v1/classifiers/%s";
    private static final String URL = "https://gateway.watsonplatform.net/natural-language-classifier/api";

    public NaturalLanguageClassifier() {
        super(SERVICE_NAME);
        if (this.getEndPoint() == null || this.getEndPoint().isEmpty()) {
            this.setEndPoint(URL);
        }
    }

    public NaturalLanguageClassifier(String username, String password) {
        this();
        this.setUsernameAndPassword(username, password);
    }

    public ServiceCall<Classification> classify(String classifierId, String text) {
        Validator.isTrue((classifierId != null && !classifierId.isEmpty() ? 1 : 0) != 0, (String)"classifierId cannot be null or empty");
        Validator.isTrue((text != null && !text.isEmpty() ? 1 : 0) != 0, (String)"text cannot be null or empty");
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty(TEXT, text);
        String path = String.format(PATH_CLASSIFY, classifierId);
        Request request = RequestBuilder.post((String)path).bodyJson(contentJson).build();
        return this.createServiceCall(request, ResponseConverterUtils.getObject(Classification.class));
    }

    public ServiceCall<Classifier> createClassifier(String name, String language, File trainingData) {
        Validator.isTrue((trainingData != null && trainingData.exists() ? 1 : 0) != 0, (String)"trainingData cannot be null or not be found");
        Validator.isTrue((language != null && !language.isEmpty() ? 1 : 0) != 0, (String)"language cannot be null or empty");
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty(LANGUAGE, language);
        if (name != null && !name.isEmpty()) {
            contentJson.addProperty(NAME, name);
        }
        MultipartBody body = new MultipartBody.Builder().setType(MultipartBody.FORM).addPart(Headers.of((String[])new String[]{"Content-Disposition", FORM_DATA_TRAINING_DATA}), RequestBody.create((MediaType)HttpMediaType.BINARY_FILE, (File)trainingData)).addFormDataPart(TRAINING_METADATA, contentJson.toString()).build();
        Request request = RequestBuilder.post((String)PATH_CLASSIFIERS).body((RequestBody)body).build();
        return this.createServiceCall(request, ResponseConverterUtils.getObject(Classifier.class));
    }

    public ServiceCall<Void> deleteClassifier(String classifierId) {
        Validator.isTrue((classifierId != null && !classifierId.isEmpty() ? 1 : 0) != 0, (String)"classifierId cannot be null or empty");
        Request request = RequestBuilder.delete((String)String.format(PATH_CLASSIFIER, classifierId)).build();
        return this.createServiceCall(request, ResponseConverterUtils.getVoid());
    }

    public ServiceCall<Classifier> getClassifier(String classifierId) {
        Validator.isTrue((classifierId != null && !classifierId.isEmpty() ? 1 : 0) != 0, (String)"classifierId cannot be null or empty");
        Request request = RequestBuilder.get((String)String.format(PATH_CLASSIFIER, classifierId)).build();
        return this.createServiceCall(request, ResponseConverterUtils.getObject(Classifier.class));
    }

    public ServiceCall<Classifiers> getClassifiers() {
        Request request = RequestBuilder.get((String)PATH_CLASSIFIERS).build();
        return this.createServiceCall(request, ResponseConverterUtils.getObject(Classifiers.class));
    }
}

