/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.natural_language_classifier.v1;

import com.google.gson.JsonObject;
import com.ibm.watson.developer_cloud.http.RequestBuilder;
import com.ibm.watson.developer_cloud.http.ServiceCall;
import com.ibm.watson.developer_cloud.natural_language_classifier.v1.model.Classification;
import com.ibm.watson.developer_cloud.natural_language_classifier.v1.model.ClassificationCollection;
import com.ibm.watson.developer_cloud.natural_language_classifier.v1.model.Classifier;
import com.ibm.watson.developer_cloud.natural_language_classifier.v1.model.ClassifierList;
import com.ibm.watson.developer_cloud.natural_language_classifier.v1.model.ClassifyCollectionOptions;
import com.ibm.watson.developer_cloud.natural_language_classifier.v1.model.ClassifyOptions;
import com.ibm.watson.developer_cloud.natural_language_classifier.v1.model.CreateClassifierOptions;
import com.ibm.watson.developer_cloud.natural_language_classifier.v1.model.DeleteClassifierOptions;
import com.ibm.watson.developer_cloud.natural_language_classifier.v1.model.GetClassifierOptions;
import com.ibm.watson.developer_cloud.natural_language_classifier.v1.model.ListClassifiersOptions;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.service.security.IamOptions;
import com.ibm.watson.developer_cloud.util.GsonSingleton;
import com.ibm.watson.developer_cloud.util.RequestUtils;
import com.ibm.watson.developer_cloud.util.ResponseConverterUtils;
import com.ibm.watson.developer_cloud.util.Validator;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import okhttp3.HttpUrl;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;

public class NaturalLanguageClassifier
extends WatsonService {
    private static final String SERVICE_NAME = "natural_language_classifier";
    private static final String URL = "https://gateway.watsonplatform.net/natural-language-classifier/api";

    public NaturalLanguageClassifier() {
        super(SERVICE_NAME);
        if (this.getEndPoint() == null || this.getEndPoint().isEmpty()) {
            this.setEndPoint(URL);
        }
    }

    public NaturalLanguageClassifier(String username, String password) {
        this();
        this.setUsernameAndPassword(username, password);
    }

    public NaturalLanguageClassifier(IamOptions iamOptions) {
        this();
        this.setIamCredentials(iamOptions);
    }

    public ServiceCall<Classification> classify(ClassifyOptions classifyOptions) {
        Validator.notNull((Object)((Object)classifyOptions), (String)"classifyOptions cannot be null");
        String[] pathSegments = new String[]{"v1/classifiers", "classify"};
        String[] pathParameters = new String[]{classifyOptions.classifierId()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments, (String[])pathParameters));
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("text", classifyOptions.text());
        builder.bodyJson(contentJson);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(Classification.class));
    }

    public ServiceCall<ClassificationCollection> classifyCollection(ClassifyCollectionOptions classifyCollectionOptions) {
        Validator.notNull((Object)((Object)classifyCollectionOptions), (String)"classifyCollectionOptions cannot be null");
        String[] pathSegments = new String[]{"v1/classifiers", "classify_collection"};
        String[] pathParameters = new String[]{classifyCollectionOptions.classifierId()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments, (String[])pathParameters));
        JsonObject contentJson = new JsonObject();
        contentJson.add("collection", GsonSingleton.getGson().toJsonTree(classifyCollectionOptions.collection()));
        builder.bodyJson(contentJson);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(ClassificationCollection.class));
    }

    public ServiceCall<Classifier> createClassifier(CreateClassifierOptions createClassifierOptions) {
        Validator.notNull((Object)((Object)createClassifierOptions), (String)"createClassifierOptions cannot be null");
        String[] pathSegments = new String[]{"v1/classifiers"};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments));
        MultipartBody.Builder multipartBuilder = new MultipartBody.Builder();
        multipartBuilder.setType(MultipartBody.FORM);
        RequestBody trainingMetadataBody = RequestUtils.inputStreamBody((InputStream)createClassifierOptions.metadata(), (String)"application/json");
        multipartBuilder.addFormDataPart("training_metadata", createClassifierOptions.metadataFilename(), trainingMetadataBody);
        RequestBody trainingDataBody = RequestUtils.inputStreamBody((InputStream)createClassifierOptions.trainingData(), (String)"text/csv");
        multipartBuilder.addFormDataPart("training_data", createClassifierOptions.trainingDataFilename(), trainingDataBody);
        builder.body((RequestBody)multipartBuilder.build());
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(Classifier.class));
    }

    public ServiceCall<Void> deleteClassifier(DeleteClassifierOptions deleteClassifierOptions) {
        Validator.notNull((Object)((Object)deleteClassifierOptions), (String)"deleteClassifierOptions cannot be null");
        String[] pathSegments = new String[]{"v1/classifiers"};
        String[] pathParameters = new String[]{deleteClassifierOptions.classifierId()};
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments, (String[])pathParameters));
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getVoid());
    }

    public ServiceCall<Classifier> getClassifier(GetClassifierOptions getClassifierOptions) {
        Validator.notNull((Object)((Object)getClassifierOptions), (String)"getClassifierOptions cannot be null");
        String[] pathSegments = new String[]{"v1/classifiers"};
        String[] pathParameters = new String[]{getClassifierOptions.classifierId()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments, (String[])pathParameters));
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(Classifier.class));
    }

    public ServiceCall<ClassifierList> listClassifiers(ListClassifiersOptions listClassifiersOptions) {
        String[] pathSegments = new String[]{"v1/classifiers"};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments));
        if (listClassifiersOptions != null) {
            // empty if block
        }
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(ClassifierList.class));
    }

    public ServiceCall<ClassifierList> listClassifiers() {
        return this.listClassifiers(null);
    }

    public ServiceCall<Classification> classify(String classifierId, String text) {
        ClassifyOptions classifyOptions = new ClassifyOptions.Builder().classifierId(classifierId).text(text).build();
        return this.classify(classifyOptions);
    }

    public ServiceCall<Classifier> createClassifier(String name, String language, File trainingData) throws FileNotFoundException {
        HashMap<String, String> metadataMap = new HashMap<String, String>();
        metadataMap.put("name", name);
        metadataMap.put("language", language);
        String metadataString = GsonSingleton.getGson().toJson(metadataMap);
        CreateClassifierOptions createClassifierOptions = new CreateClassifierOptions.Builder().metadata(new ByteArrayInputStream(metadataString.getBytes())).trainingData(trainingData).build();
        return this.createClassifier(createClassifierOptions);
    }

    public ServiceCall<Void> deleteClassifier(String classifierId) {
        DeleteClassifierOptions deleteClassifierOptions = new DeleteClassifierOptions.Builder().classifierId(classifierId).build();
        return this.deleteClassifier(deleteClassifierOptions);
    }

    public ServiceCall<Classifier> getClassifier(String classifierId) {
        GetClassifierOptions getClassifierOptions = new GetClassifierOptions.Builder().classifierId(classifierId).build();
        return this.getClassifier(getClassifierOptions);
    }

    public ServiceCall<ClassifierList> getClassifiers() {
        return this.listClassifiers();
    }
}

