/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.natural_language_classifier.v1.model;

import com.ibm.watson.developer_cloud.natural_language_classifier.v1.model.ClassifyInput;
import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class ClassifyCollectionOptions
extends GenericModel {
    private String classifierId;
    private List<ClassifyInput> collection;

    private ClassifyCollectionOptions(Builder builder) {
        Validator.notEmpty((String)builder.classifierId, (String)"classifierId cannot be empty");
        Validator.notNull((Object)builder.collection, (String)"collection cannot be null");
        this.classifierId = builder.classifierId;
        this.collection = builder.collection;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String classifierId() {
        return this.classifierId;
    }

    public List<ClassifyInput> collection() {
        return this.collection;
    }

    public static class Builder {
        private String classifierId;
        private List<ClassifyInput> collection;

        private Builder(ClassifyCollectionOptions classifyCollectionOptions) {
            this.classifierId = classifyCollectionOptions.classifierId;
            this.collection = classifyCollectionOptions.collection;
        }

        public Builder() {
        }

        public Builder(String classifierId, List<ClassifyInput> collection) {
            this.classifierId = classifierId;
            this.collection = collection;
        }

        public ClassifyCollectionOptions build() {
            return new ClassifyCollectionOptions(this);
        }

        public Builder addClassifyInput(ClassifyInput classifyInput) {
            Validator.notNull((Object)((Object)classifyInput), (String)"classifyInput cannot be null");
            if (this.collection == null) {
                this.collection = new ArrayList<ClassifyInput>();
            }
            this.collection.add(classifyInput);
            return this;
        }

        public Builder classifierId(String classifierId) {
            this.classifierId = classifierId;
            return this;
        }

        public Builder collection(List<ClassifyInput> collection) {
            this.collection = collection;
            return this;
        }
    }
}

