/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.natural_language_understanding.v1;

import com.google.gson.JsonObject;
import com.ibm.watson.developer_cloud.http.RequestBuilder;
import com.ibm.watson.developer_cloud.http.ServiceCall;
import com.ibm.watson.developer_cloud.natural_language_understanding.v1.model.AnalysisResults;
import com.ibm.watson.developer_cloud.natural_language_understanding.v1.model.AnalyzeOptions;
import com.ibm.watson.developer_cloud.natural_language_understanding.v1.model.DeleteModelOptions;
import com.ibm.watson.developer_cloud.natural_language_understanding.v1.model.ListModelsOptions;
import com.ibm.watson.developer_cloud.natural_language_understanding.v1.model.ListModelsResults;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.service.security.IamOptions;
import com.ibm.watson.developer_cloud.util.GsonSingleton;
import com.ibm.watson.developer_cloud.util.ResponseConverterUtils;
import com.ibm.watson.developer_cloud.util.Validator;
import okhttp3.HttpUrl;

public class NaturalLanguageUnderstanding
extends WatsonService {
    private static final String SERVICE_NAME = "natural_language_understanding";
    private static final String URL = "https://gateway.watsonplatform.net/natural-language-understanding/api";
    private String versionDate;

    public NaturalLanguageUnderstanding(String versionDate) {
        super(SERVICE_NAME);
        if (this.getEndPoint() == null || this.getEndPoint().isEmpty()) {
            this.setEndPoint(URL);
        }
        Validator.isTrue((versionDate != null && !versionDate.isEmpty() ? 1 : 0) != 0, (String)"version cannot be null.");
        this.versionDate = versionDate;
    }

    public NaturalLanguageUnderstanding(String versionDate, String username, String password) {
        this(versionDate);
        this.setUsernameAndPassword(username, password);
    }

    public NaturalLanguageUnderstanding(String versionDate, IamOptions iamOptions) {
        this(versionDate);
        this.setIamCredentials(iamOptions);
    }

    public ServiceCall<AnalysisResults> analyze(AnalyzeOptions analyzeOptions) {
        Validator.notNull((Object)((Object)analyzeOptions), (String)"analyzeOptions cannot be null");
        String[] pathSegments = new String[]{"v1/analyze"};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments));
        builder.query(new Object[]{"version", this.versionDate});
        JsonObject contentJson = new JsonObject();
        if (analyzeOptions.text() != null) {
            contentJson.addProperty("text", analyzeOptions.text());
        }
        if (analyzeOptions.html() != null) {
            contentJson.addProperty("html", analyzeOptions.html());
        }
        if (analyzeOptions.url() != null) {
            contentJson.addProperty("url", analyzeOptions.url());
        }
        contentJson.add("features", GsonSingleton.getGson().toJsonTree((Object)analyzeOptions.features()));
        if (analyzeOptions.clean() != null) {
            contentJson.addProperty("clean", analyzeOptions.clean());
        }
        if (analyzeOptions.xpath() != null) {
            contentJson.addProperty("xpath", analyzeOptions.xpath());
        }
        if (analyzeOptions.fallbackToRaw() != null) {
            contentJson.addProperty("fallback_to_raw", analyzeOptions.fallbackToRaw());
        }
        if (analyzeOptions.returnAnalyzedText() != null) {
            contentJson.addProperty("return_analyzed_text", analyzeOptions.returnAnalyzedText());
        }
        if (analyzeOptions.language() != null) {
            contentJson.addProperty("language", analyzeOptions.language());
        }
        if (analyzeOptions.limitTextCharacters() != null) {
            contentJson.addProperty("limit_text_characters", (Number)analyzeOptions.limitTextCharacters());
        }
        builder.bodyJson(contentJson);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(AnalysisResults.class));
    }

    public ServiceCall<Void> deleteModel(DeleteModelOptions deleteModelOptions) {
        Validator.notNull((Object)((Object)deleteModelOptions), (String)"deleteModelOptions cannot be null");
        String[] pathSegments = new String[]{"v1/models"};
        String[] pathParameters = new String[]{deleteModelOptions.modelId()};
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getVoid());
    }

    public ServiceCall<ListModelsResults> listModels(ListModelsOptions listModelsOptions) {
        String[] pathSegments = new String[]{"v1/models"};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments));
        builder.query(new Object[]{"version", this.versionDate});
        if (listModelsOptions != null) {
            // empty if block
        }
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(ListModelsResults.class));
    }

    public ServiceCall<ListModelsResults> listModels() {
        return this.listModels(null);
    }
}

