/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.natural_language_understanding.v1.model;

import com.google.gson.annotations.SerializedName;
import com.ibm.watson.developer_cloud.natural_language_understanding.v1.model.CategoriesOptions;
import com.ibm.watson.developer_cloud.natural_language_understanding.v1.model.ConceptsOptions;
import com.ibm.watson.developer_cloud.natural_language_understanding.v1.model.EmotionOptions;
import com.ibm.watson.developer_cloud.natural_language_understanding.v1.model.EntitiesOptions;
import com.ibm.watson.developer_cloud.natural_language_understanding.v1.model.KeywordsOptions;
import com.ibm.watson.developer_cloud.natural_language_understanding.v1.model.MetadataOptions;
import com.ibm.watson.developer_cloud.natural_language_understanding.v1.model.RelationsOptions;
import com.ibm.watson.developer_cloud.natural_language_understanding.v1.model.SemanticRolesOptions;
import com.ibm.watson.developer_cloud.natural_language_understanding.v1.model.SentimentOptions;
import com.ibm.watson.developer_cloud.service.model.GenericModel;

public class Features
extends GenericModel {
    private ConceptsOptions concepts;
    private EmotionOptions emotion;
    private EntitiesOptions entities;
    private KeywordsOptions keywords;
    private MetadataOptions metadata;
    private RelationsOptions relations;
    @SerializedName(value="semantic_roles")
    private SemanticRolesOptions semanticRoles;
    private SentimentOptions sentiment;
    private CategoriesOptions categories;

    private Features(Builder builder) {
        this.concepts = builder.concepts;
        this.emotion = builder.emotion;
        this.entities = builder.entities;
        this.keywords = builder.keywords;
        this.metadata = builder.metadata;
        this.relations = builder.relations;
        this.semanticRoles = builder.semanticRoles;
        this.sentiment = builder.sentiment;
        this.categories = builder.categories;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public ConceptsOptions concepts() {
        return this.concepts;
    }

    public EmotionOptions emotion() {
        return this.emotion;
    }

    public EntitiesOptions entities() {
        return this.entities;
    }

    public KeywordsOptions keywords() {
        return this.keywords;
    }

    public MetadataOptions metadata() {
        return this.metadata;
    }

    public RelationsOptions relations() {
        return this.relations;
    }

    public SemanticRolesOptions semanticRoles() {
        return this.semanticRoles;
    }

    public SentimentOptions sentiment() {
        return this.sentiment;
    }

    public CategoriesOptions categories() {
        return this.categories;
    }

    public static class Builder {
        private ConceptsOptions concepts;
        private EmotionOptions emotion;
        private EntitiesOptions entities;
        private KeywordsOptions keywords;
        private MetadataOptions metadata;
        private RelationsOptions relations;
        private SemanticRolesOptions semanticRoles;
        private SentimentOptions sentiment;
        private CategoriesOptions categories;

        private Builder(Features features) {
            this.concepts = features.concepts;
            this.emotion = features.emotion;
            this.entities = features.entities;
            this.keywords = features.keywords;
            this.metadata = features.metadata;
            this.relations = features.relations;
            this.semanticRoles = features.semanticRoles;
            this.sentiment = features.sentiment;
            this.categories = features.categories;
        }

        public Builder() {
        }

        public Features build() {
            return new Features(this);
        }

        public Builder concepts(ConceptsOptions concepts) {
            this.concepts = concepts;
            return this;
        }

        public Builder emotion(EmotionOptions emotion) {
            this.emotion = emotion;
            return this;
        }

        public Builder entities(EntitiesOptions entities) {
            this.entities = entities;
            return this;
        }

        public Builder keywords(KeywordsOptions keywords) {
            this.keywords = keywords;
            return this;
        }

        public Builder metadata(MetadataOptions metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder relations(RelationsOptions relations) {
            this.relations = relations;
            return this;
        }

        public Builder semanticRoles(SemanticRolesOptions semanticRoles) {
            this.semanticRoles = semanticRoles;
            return this;
        }

        public Builder sentiment(SentimentOptions sentiment) {
            this.sentiment = sentiment;
            return this;
        }

        public Builder categories(CategoriesOptions categories) {
            this.categories = categories;
            return this;
        }
    }
}

