/*
 * Copyright 2018 IBM Corp. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package com.ibm.watson.developer_cloud.speech_to_text.v1.model;

import java.util.List;

import com.google.gson.annotations.SerializedName;
import com.ibm.watson.developer_cloud.service.model.GenericModel;

/**
 * Word.
 */
public class Word extends GenericModel {

  private String word;
  @SerializedName("sounds_like")
  private List<String> soundsLike;
  @SerializedName("display_as")
  private String displayAs;
  private Long count;
  private List<String> source;
  private List<WordError> error;

  /**
   * Gets the word.
   *
   * A word from the custom model's words resource. The spelling of the word is used to train the model.
   *
   * @return the word
   */
  public String getWord() {
    return word;
  }

  /**
   * Gets the soundsLike.
   *
   * An array of pronunciations for the word. The array can include the sounds-like pronunciation automatically
   * generated by the service if none is provided for the word; the service adds this pronunciation when it finishes
   * processing the word.
   *
   * @return the soundsLike
   */
  public List<String> getSoundsLike() {
    return soundsLike;
  }

  /**
   * Gets the displayAs.
   *
   * The spelling of the word that the service uses to display the word in a transcript. The field contains an empty
   * string if no display-as value is provided for the word, in which case the word is displayed as it is spelled.
   *
   * @return the displayAs
   */
  public String getDisplayAs() {
    return displayAs;
  }

  /**
   * Gets the count.
   *
   * A sum of the number of times the word is found across all corpora. For example, if the word occurs five times in
   * one corpus and seven times in another, its count is `12`. If you add a custom word to a model before it is added by
   * any corpora, the count begins at `1`; if the word is added from a corpus first and later modified, the count
   * reflects only the number of times it is found in corpora.
   *
   * @return the count
   */
  public Long getCount() {
    return count;
  }

  /**
   * Gets the source.
   *
   * An array of sources that describes how the word was added to the custom model's words resource. For OOV words added
   * from a corpus, includes the name of the corpus; if the word was added by multiple corpora, the names of all corpora
   * are listed. If the word was modified or added by the user directly, the field includes the string `user`.
   *
   * @return the source
   */
  public List<String> getSource() {
    return source;
  }

  /**
   * Gets the error.
   *
   * If the service discovered one or more problems that you need to correct for the word's definition, an array that
   * describes each of the errors.
   *
   * @return the error
   */
  public List<WordError> getError() {
    return error;
  }
}
