/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.visual_recognition.v3;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.reflect.TypeToken;
import com.ibm.watson.developer_cloud.http.HttpMediaType;
import com.ibm.watson.developer_cloud.http.RequestBuilder;
import com.ibm.watson.developer_cloud.http.ResponseConverter;
import com.ibm.watson.developer_cloud.http.ServiceCall;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.util.ResponseConverterUtils;
import com.ibm.watson.developer_cloud.util.Validator;
import com.ibm.watson.developer_cloud.visual_recognition.v3.model.ClassifierOptions;
import com.ibm.watson.developer_cloud.visual_recognition.v3.model.ClassifyImagesOptions;
import com.ibm.watson.developer_cloud.visual_recognition.v3.model.DetectedFaces;
import com.ibm.watson.developer_cloud.visual_recognition.v3.model.RecognizedText;
import com.ibm.watson.developer_cloud.visual_recognition.v3.model.VisualClassification;
import com.ibm.watson.developer_cloud.visual_recognition.v3.model.VisualClassifier;
import com.ibm.watson.developer_cloud.visual_recognition.v3.model.VisualRecognitionOptions;
import java.io.File;
import java.lang.reflect.Type;
import java.util.List;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;

public class VisualRecognition
extends WatsonService {
    private static final String PARAM_API_KEY = "api_key";
    private static final String PARAM_CLASSIFIERS = "classifiers";
    private static final String PARAM_IMAGES_FILE = "images_file";
    private static final String PARAM_NAME = "name";
    private static final String PARAM_NEGATIVE_EXAMPLES = "negative_examples";
    private static final String PARAM_PARAMETERS = "parameters";
    private static final String PARAM_POSITIVE_EXAMPLES = "positive_examples";
    private static final String PARAM_URL = "url";
    private static final String PARAM_CLASSIFIER_IDS = "classifier_ids";
    private static final String PARAM_THRESHOLD = "threshold";
    private static final String PATH_CLASSIFIER = "/v3/classifiers/%s";
    private static final String PATH_CLASSIFIERS = "/v3/classifiers";
    private static final String PATH_CLASSIFY = "/v3/classify";
    private static final String PATH_DETECT_FACES = "/v3/detect_faces";
    private static final String PATH_RECOGNIZE_TEXT = "/v3/recognize_text";
    private static final String SERVICE_NAME = "watson_vision_combined";
    private static final Type TYPE_LIST_CLASSIFIERS = new TypeToken<List<VisualClassifier>>(){}.getType();
    private static final String URL = "https://gateway-a.watsonplatform.net/visual-recognition/api";
    private static final String VERBOSE = "verbose";
    public static final String VERSION_DATE_2016_05_20 = "2016-05-20";
    private String versionDate;

    public VisualRecognition(String versionDate) {
        super(SERVICE_NAME);
        if (this.getEndPoint() == null || this.getEndPoint().isEmpty()) {
            this.setEndPoint(URL);
        }
        Validator.notNull((Object)versionDate, (String)"versionDate cannot be null. Use '2016-05-19'");
        this.versionDate = versionDate;
    }

    public VisualRecognition(String versionDate, String apiKey) {
        this(versionDate);
        this.setApiKey(apiKey);
    }

    private void addApiKeyToRequest(Request.Builder builder, String apiKey) {
        HttpUrl url = HttpUrl.parse((String)builder.build().url().toString());
        if (url.query() == null || url.query().isEmpty()) {
            builder.url(builder.build().url() + "?" + apiKey);
        } else {
            builder.url(builder.build().url() + "&" + apiKey);
        }
    }

    private JsonObject getParametersAsJson(ClassifyImagesOptions options) {
        JsonObject ret = new JsonObject();
        if (options.url() != null && options.images() == null) {
            ret.addProperty(PARAM_URL, options.url().toString());
        }
        if (options.classifierIds() != null && !options.classifierIds().isEmpty()) {
            JsonArray array = new JsonArray();
            for (String cId : options.classifierIds()) {
                array.add((JsonElement)new JsonPrimitive(cId));
            }
            ret.add(PARAM_CLASSIFIER_IDS, (JsonElement)array);
        }
        if (options.threshold() != null) {
            ret.addProperty(PARAM_THRESHOLD, (Number)options.threshold());
        }
        return ret;
    }

    private JsonObject getParametersAsJson(VisualRecognitionOptions options) {
        JsonObject ret = new JsonObject();
        ret.addProperty(PARAM_URL, options.url().toString());
        return ret;
    }

    protected void setAuthentication(Request.Builder builder) {
        if (this.getApiKey() == null) {
            throw new IllegalArgumentException("api_key needs to be specified. Use setApiKey()");
        }
        this.addApiKeyToRequest(builder, "api_key=" + this.getApiKey());
    }

    public ServiceCall<VisualClassification> classify(ClassifyImagesOptions options) {
        Validator.notNull((Object)options, (String)"'options' cannot be null");
        MultipartBody.Builder bodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        if (options.images() != null) {
            RequestBody requestBody = RequestBody.create((MediaType)HttpMediaType.BINARY_FILE, (File)options.images());
            bodyBuilder.addFormDataPart(PARAM_IMAGES_FILE, options.images().getName(), requestBody);
        }
        bodyBuilder.addFormDataPart(PARAM_PARAMETERS, this.getParametersAsJson(options).toString());
        RequestBuilder requestBuilder = RequestBuilder.post((String)PATH_CLASSIFY);
        requestBuilder.query(new Object[]{"version", this.versionDate}).body((RequestBody)bodyBuilder.build());
        return this.createServiceCall(requestBuilder.build(), ResponseConverterUtils.getObject(VisualClassification.class));
    }

    public ServiceCall<VisualClassifier> createClassifier(ClassifierOptions options) {
        Validator.notNull((Object)options, (String)" options cannot be null");
        this.validateClassifierOptions(options);
        MultipartBody.Builder bodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        bodyBuilder.addFormDataPart(PARAM_NAME, options.classifierName());
        for (String className : options.classNames()) {
            String dataName = className + "_" + PARAM_POSITIVE_EXAMPLES;
            RequestBody requestBody = RequestBody.create((MediaType)HttpMediaType.BINARY_FILE, (File)options.positiveExamplesByClassName(className));
            bodyBuilder.addFormDataPart(dataName, options.positiveExamplesByClassName(className).getName(), requestBody);
        }
        if (options.negativeExamples() != null) {
            RequestBody requestBody = RequestBody.create((MediaType)HttpMediaType.BINARY_FILE, (File)options.negativeExamples());
            bodyBuilder.addFormDataPart(PARAM_NEGATIVE_EXAMPLES, options.negativeExamples().getName(), requestBody);
        }
        RequestBuilder requestBuilder = RequestBuilder.post((String)PATH_CLASSIFIERS);
        requestBuilder.query(new Object[]{"version", this.versionDate}).body((RequestBody)bodyBuilder.build());
        return this.createServiceCall(requestBuilder.build(), ResponseConverterUtils.getObject(VisualClassifier.class));
    }

    private void validateClassifierOptions(ClassifierOptions options) {
        String errorMessage = "To create a classifier, you must supply at least 2 zip files - either 2 positive example sets, or 1 positive and 1 negative set";
        Validator.notNull((Object)options.classifierName(), (String)"'classifierName' cannot be null");
        Validator.isTrue((!options.classNames().isEmpty() ? 1 : 0) != 0, (String)("There are no classes. " + errorMessage));
        boolean hasExamples = options.classNames().size() > 1 || options.negativeExamples() != null && options.classNames().size() == 1;
        Validator.isTrue((boolean)hasExamples, (String)errorMessage);
    }

    public ServiceCall<VisualClassifier> updateClassifier(String classifierId, ClassifierOptions options) {
        Validator.notNull((Object)classifierId, (String)"classifierId cannot be null");
        Validator.notNull((Object)options, (String)" options cannot be null");
        String errorMessage = "To update a classifier, you must supply at least 1 zip file - either a positive or negative zip file.";
        Validator.isTrue((!options.classNames().isEmpty() || options.negativeExamples() != null ? 1 : 0) != 0, (String)errorMessage);
        MultipartBody.Builder bodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        for (String className : options.classNames()) {
            String dataName = className + "_" + PARAM_POSITIVE_EXAMPLES;
            RequestBody requestBody = RequestBody.create((MediaType)HttpMediaType.BINARY_FILE, (File)options.positiveExamplesByClassName(className));
            bodyBuilder.addFormDataPart(dataName, options.positiveExamplesByClassName(className).getName(), requestBody);
        }
        if (options.negativeExamples() != null) {
            RequestBody requestBody = RequestBody.create((MediaType)HttpMediaType.BINARY_FILE, (File)options.negativeExamples());
            bodyBuilder.addFormDataPart(PARAM_NEGATIVE_EXAMPLES, options.negativeExamples().getName(), requestBody);
        }
        RequestBuilder requestBuilder = RequestBuilder.post((String)String.format(PATH_CLASSIFIER, classifierId));
        requestBuilder.query(new Object[]{"version", this.versionDate}).body((RequestBody)bodyBuilder.build());
        return this.createServiceCall(requestBuilder.build(), ResponseConverterUtils.getObject(VisualClassifier.class));
    }

    public ServiceCall<Void> deleteClassifier(String classifierId) {
        Validator.isTrue((classifierId != null && !classifierId.isEmpty() ? 1 : 0) != 0, (String)"classifierId cannot be null or empty");
        RequestBuilder requestBuilder = RequestBuilder.delete((String)String.format(PATH_CLASSIFIER, classifierId));
        requestBuilder.query(new Object[]{"version", this.versionDate});
        return this.createServiceCall(requestBuilder.build(), ResponseConverterUtils.getVoid());
    }

    public ServiceCall<DetectedFaces> detectFaces(VisualRecognitionOptions options) {
        MultipartBody.Builder bodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        if (options.url() != null) {
            bodyBuilder.addFormDataPart(PARAM_PARAMETERS, this.getParametersAsJson(options).toString());
        } else {
            RequestBody requestBody = RequestBody.create((MediaType)HttpMediaType.BINARY_FILE, (File)options.images());
            bodyBuilder.addFormDataPart(PARAM_IMAGES_FILE, options.images().getName(), requestBody);
        }
        RequestBuilder requestBuilder = RequestBuilder.post((String)PATH_DETECT_FACES);
        requestBuilder.query(new Object[]{"version", this.versionDate}).body((RequestBody)bodyBuilder.build());
        return this.createServiceCall(requestBuilder.build(), ResponseConverterUtils.getObject(DetectedFaces.class));
    }

    public ServiceCall<VisualClassifier> getClassifier(String classifierId) {
        Validator.isTrue((classifierId != null && !classifierId.isEmpty() ? 1 : 0) != 0, (String)"classifierId cannot be null or empty");
        RequestBuilder requestBuilder = RequestBuilder.get((String)String.format(PATH_CLASSIFIER, classifierId));
        requestBuilder.query(new Object[]{"version", this.versionDate});
        return this.createServiceCall(requestBuilder.build(), ResponseConverterUtils.getObject(VisualClassifier.class));
    }

    public ServiceCall<List<VisualClassifier>> getClassifiers() {
        RequestBuilder requestBuilder = RequestBuilder.get((String)PATH_CLASSIFIERS).query(new Object[]{"version", this.versionDate}).query(new Object[]{VERBOSE, true});
        ResponseConverter converter = ResponseConverterUtils.getGenericObject((Type)TYPE_LIST_CLASSIFIERS, (String)PARAM_CLASSIFIERS);
        return this.createServiceCall(requestBuilder.build(), converter);
    }

    public ServiceCall<RecognizedText> recognizeText(VisualRecognitionOptions options) {
        MultipartBody.Builder bodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        if (options.url() != null) {
            bodyBuilder.addFormDataPart(PARAM_PARAMETERS, this.getParametersAsJson(options).toString());
        } else {
            RequestBody requestBody = RequestBody.create((MediaType)HttpMediaType.BINARY_FILE, (File)options.images());
            bodyBuilder.addFormDataPart(PARAM_IMAGES_FILE, options.images().getName(), requestBody);
        }
        RequestBuilder requestBuilder = RequestBuilder.post((String)PATH_RECOGNIZE_TEXT);
        requestBuilder.query(new Object[]{"version", this.versionDate}).body((RequestBody)bodyBuilder.build());
        return this.createServiceCall(requestBuilder.build(), ResponseConverterUtils.getObject(RecognizedText.class));
    }

    @Deprecated
    public void setUsernameAndPassword(String username, String password) {
        throw new IllegalArgumentException("This service requires an api_key. Use the setApiKey() method instead");
    }
}

