/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.visual_recognition.v3;

import com.ibm.watson.developer_cloud.http.RequestBuilder;
import com.ibm.watson.developer_cloud.http.ServiceCall;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.service.security.IamOptions;
import com.ibm.watson.developer_cloud.util.RequestUtils;
import com.ibm.watson.developer_cloud.util.ResponseConverterUtils;
import com.ibm.watson.developer_cloud.util.Validator;
import com.ibm.watson.developer_cloud.visual_recognition.v3.model.ClassifiedImages;
import com.ibm.watson.developer_cloud.visual_recognition.v3.model.Classifier;
import com.ibm.watson.developer_cloud.visual_recognition.v3.model.Classifiers;
import com.ibm.watson.developer_cloud.visual_recognition.v3.model.ClassifyOptions;
import com.ibm.watson.developer_cloud.visual_recognition.v3.model.CreateClassifierOptions;
import com.ibm.watson.developer_cloud.visual_recognition.v3.model.DeleteClassifierOptions;
import com.ibm.watson.developer_cloud.visual_recognition.v3.model.DeleteUserDataOptions;
import com.ibm.watson.developer_cloud.visual_recognition.v3.model.DetectFacesOptions;
import com.ibm.watson.developer_cloud.visual_recognition.v3.model.DetectedFaces;
import com.ibm.watson.developer_cloud.visual_recognition.v3.model.GetClassifierOptions;
import com.ibm.watson.developer_cloud.visual_recognition.v3.model.GetCoreMlModelOptions;
import com.ibm.watson.developer_cloud.visual_recognition.v3.model.ListClassifiersOptions;
import com.ibm.watson.developer_cloud.visual_recognition.v3.model.UpdateClassifierOptions;
import java.io.InputStream;
import java.util.Map;
import okhttp3.HttpUrl;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;

public class VisualRecognition
extends WatsonService {
    private static final String SERVICE_NAME = "visual_recognition";
    private static final String URL = "https://gateway.watsonplatform.net/visual-recognition/api";
    private String versionDate;

    public VisualRecognition(String versionDate) {
        super(SERVICE_NAME);
        if (this.getEndPoint() == null || this.getEndPoint().isEmpty()) {
            this.setEndPoint(URL);
        }
        Validator.isTrue((versionDate != null && !versionDate.isEmpty() ? 1 : 0) != 0, (String)"version cannot be null.");
        this.versionDate = versionDate;
    }

    public VisualRecognition(String versionDate, String apiKey) {
        this(versionDate);
        this.setApiKey(apiKey);
    }

    protected void setAuthentication(Request.Builder builder) {
        if (this.getUsername() != null && this.getPassword() != null || this.isTokenManagerSet()) {
            super.setAuthentication(builder);
        } else if (this.getApiKey() != null) {
            this.addApiKeyQueryParameter(builder, this.getApiKey());
        } else {
            throw new IllegalArgumentException("Credentials need to be specified. Use setApiKey(), setIamCredentials(), or setUsernameAndPassword().");
        }
    }

    private void addApiKeyQueryParameter(Request.Builder builder, String apiKey) {
        HttpUrl url = HttpUrl.parse((String)builder.build().url().toString());
        if (url.query() == null || url.query().isEmpty()) {
            builder.url(builder.build().url() + "?api_key=" + apiKey);
        } else {
            builder.url(builder.build().url() + "&api_key=" + apiKey);
        }
    }

    public VisualRecognition(String versionDate, IamOptions iamOptions) {
        this(versionDate);
        this.setIamCredentials(iamOptions);
    }

    public ServiceCall<ClassifiedImages> classify(ClassifyOptions classifyOptions) {
        Validator.notNull((Object)((Object)classifyOptions), (String)"classifyOptions cannot be null");
        Validator.isTrue((classifyOptions.imagesFile() != null || classifyOptions.url() != null || classifyOptions.threshold() != null || classifyOptions.owners() != null || classifyOptions.classifierIds() != null || classifyOptions.parameters() != null ? 1 : 0) != 0, (String)"At least one of imagesFile, url, threshold, owners, classifierIds, or parameters must be supplied.");
        String[] pathSegments = new String[]{"v3/classify"};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments));
        builder.query(new Object[]{"version", this.versionDate});
        if (classifyOptions.acceptLanguage() != null) {
            builder.header(new Object[]{"Accept-Language", classifyOptions.acceptLanguage()});
        }
        MultipartBody.Builder multipartBuilder = new MultipartBody.Builder();
        multipartBuilder.setType(MultipartBody.FORM);
        if (classifyOptions.imagesFile() != null) {
            RequestBody imagesFileBody = RequestUtils.inputStreamBody((InputStream)classifyOptions.imagesFile(), (String)classifyOptions.imagesFileContentType());
            multipartBuilder.addFormDataPart("images_file", classifyOptions.imagesFilename(), imagesFileBody);
        }
        if (classifyOptions.parameters() != null) {
            multipartBuilder.addFormDataPart("parameters", classifyOptions.parameters());
        }
        if (classifyOptions.url() != null) {
            multipartBuilder.addFormDataPart("url", classifyOptions.url());
        }
        if (classifyOptions.threshold() != null) {
            multipartBuilder.addFormDataPart("threshold", String.valueOf(classifyOptions.threshold()));
        }
        if (classifyOptions.owners() != null) {
            multipartBuilder.addFormDataPart("owners", RequestUtils.join(classifyOptions.owners(), (String)","));
        }
        if (classifyOptions.classifierIds() != null) {
            multipartBuilder.addFormDataPart("classifier_ids", RequestUtils.join(classifyOptions.classifierIds(), (String)","));
        }
        builder.body((RequestBody)multipartBuilder.build());
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(ClassifiedImages.class));
    }

    public ServiceCall<ClassifiedImages> classify() {
        return this.classify(null);
    }

    public ServiceCall<DetectedFaces> detectFaces(DetectFacesOptions detectFacesOptions) {
        Validator.notNull((Object)((Object)detectFacesOptions), (String)"detectFacesOptions cannot be null");
        Validator.isTrue((detectFacesOptions.imagesFile() != null || detectFacesOptions.url() != null || detectFacesOptions.parameters() != null ? 1 : 0) != 0, (String)"At least one of imagesFile, url, or parameters must be supplied.");
        String[] pathSegments = new String[]{"v3/detect_faces"};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments));
        builder.query(new Object[]{"version", this.versionDate});
        MultipartBody.Builder multipartBuilder = new MultipartBody.Builder();
        multipartBuilder.setType(MultipartBody.FORM);
        if (detectFacesOptions.imagesFile() != null) {
            RequestBody imagesFileBody = RequestUtils.inputStreamBody((InputStream)detectFacesOptions.imagesFile(), (String)detectFacesOptions.imagesFileContentType());
            multipartBuilder.addFormDataPart("images_file", detectFacesOptions.imagesFilename(), imagesFileBody);
        }
        if (detectFacesOptions.parameters() != null) {
            multipartBuilder.addFormDataPart("parameters", detectFacesOptions.parameters());
        }
        if (detectFacesOptions.url() != null) {
            multipartBuilder.addFormDataPart("url", detectFacesOptions.url());
        }
        builder.body((RequestBody)multipartBuilder.build());
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(DetectedFaces.class));
    }

    public ServiceCall<DetectedFaces> detectFaces() {
        return this.detectFaces(null);
    }

    public ServiceCall<Classifier> createClassifier(CreateClassifierOptions createClassifierOptions) {
        Validator.notNull((Object)((Object)createClassifierOptions), (String)"createClassifierOptions cannot be null");
        String[] pathSegments = new String[]{"v3/classifiers"};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments));
        builder.query(new Object[]{"version", this.versionDate});
        MultipartBody.Builder multipartBuilder = new MultipartBody.Builder();
        multipartBuilder.setType(MultipartBody.FORM);
        multipartBuilder.addFormDataPart("name", createClassifierOptions.name());
        for (Map.Entry<String, InputStream> entry : createClassifierOptions.positiveExamples().entrySet()) {
            String partName = String.format("%s_positive_examples", entry.getKey());
            String fileName = createClassifierOptions.positiveExamplesFilename() != null ? createClassifierOptions.positiveExamplesFilename().get(entry.getKey()) : null;
            RequestBody part = RequestUtils.inputStreamBody((InputStream)entry.getValue(), (String)"application/octet-stream");
            multipartBuilder.addFormDataPart(partName, fileName, part);
        }
        if (createClassifierOptions.negativeExamples() != null) {
            RequestBody negativeExamplesBody = RequestUtils.inputStreamBody((InputStream)createClassifierOptions.negativeExamples(), (String)"application/octet-stream");
            multipartBuilder.addFormDataPart("negative_examples", createClassifierOptions.negativeExamplesFilename(), negativeExamplesBody);
        }
        builder.body((RequestBody)multipartBuilder.build());
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(Classifier.class));
    }

    public ServiceCall<Void> deleteClassifier(DeleteClassifierOptions deleteClassifierOptions) {
        Validator.notNull((Object)((Object)deleteClassifierOptions), (String)"deleteClassifierOptions cannot be null");
        String[] pathSegments = new String[]{"v3/classifiers"};
        String[] pathParameters = new String[]{deleteClassifierOptions.classifierId()};
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getVoid());
    }

    public ServiceCall<Classifier> getClassifier(GetClassifierOptions getClassifierOptions) {
        Validator.notNull((Object)((Object)getClassifierOptions), (String)"getClassifierOptions cannot be null");
        String[] pathSegments = new String[]{"v3/classifiers"};
        String[] pathParameters = new String[]{getClassifierOptions.classifierId()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(Classifier.class));
    }

    public ServiceCall<Classifiers> listClassifiers(ListClassifiersOptions listClassifiersOptions) {
        String[] pathSegments = new String[]{"v3/classifiers"};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments));
        builder.query(new Object[]{"version", this.versionDate});
        if (listClassifiersOptions != null && listClassifiersOptions.verbose() != null) {
            builder.query(new Object[]{"verbose", String.valueOf(listClassifiersOptions.verbose())});
        }
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(Classifiers.class));
    }

    public ServiceCall<Classifiers> listClassifiers() {
        return this.listClassifiers(null);
    }

    public ServiceCall<Classifier> updateClassifier(UpdateClassifierOptions updateClassifierOptions) {
        Validator.notNull((Object)((Object)updateClassifierOptions), (String)"updateClassifierOptions cannot be null");
        Validator.isTrue((updateClassifierOptions.positiveExamples() != null || updateClassifierOptions.negativeExamples() != null ? 1 : 0) != 0, (String)"At least one of positiveExamples or negativeExamples must be supplied.");
        String[] pathSegments = new String[]{"v3/classifiers"};
        String[] pathParameters = new String[]{updateClassifierOptions.classifierId()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        MultipartBody.Builder multipartBuilder = new MultipartBody.Builder();
        multipartBuilder.setType(MultipartBody.FORM);
        if (updateClassifierOptions.positiveExamples() != null) {
            for (Map.Entry<String, InputStream> entry : updateClassifierOptions.positiveExamples().entrySet()) {
                String partName = String.format("%s_positive_examples", entry.getKey());
                String fileName = updateClassifierOptions.positiveExamplesFilename() != null ? updateClassifierOptions.positiveExamplesFilename().get(entry.getKey()) : null;
                RequestBody part = RequestUtils.inputStreamBody((InputStream)entry.getValue(), (String)"application/octet-stream");
                multipartBuilder.addFormDataPart(partName, fileName, part);
            }
        }
        if (updateClassifierOptions.negativeExamples() != null) {
            RequestBody negativeExamplesBody = RequestUtils.inputStreamBody((InputStream)updateClassifierOptions.negativeExamples(), (String)"application/octet-stream");
            multipartBuilder.addFormDataPart("negative_examples", updateClassifierOptions.negativeExamplesFilename(), negativeExamplesBody);
        }
        builder.body((RequestBody)multipartBuilder.build());
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(Classifier.class));
    }

    public ServiceCall<InputStream> getCoreMlModel(GetCoreMlModelOptions getCoreMlModelOptions) {
        Validator.notNull((Object)((Object)getCoreMlModelOptions), (String)"getCoreMlModelOptions cannot be null");
        String[] pathSegments = new String[]{"v3/classifiers", "core_ml_model"};
        String[] pathParameters = new String[]{getCoreMlModelOptions.classifierId()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getInputStream());
    }

    public ServiceCall<Void> deleteUserData(DeleteUserDataOptions deleteUserDataOptions) {
        Validator.notNull((Object)((Object)deleteUserDataOptions), (String)"deleteUserDataOptions cannot be null");
        String[] pathSegments = new String[]{"v3/user_data"};
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments));
        builder.query(new Object[]{"version", this.versionDate});
        builder.query(new Object[]{"customer_id", deleteUserDataOptions.customerId()});
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getVoid());
    }
}

