/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v1.model;

import com.google.gson.annotations.SerializedName;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.discovery.v1.model.EnrichmentOptions;

public class Enrichment
extends GenericModel {
    protected String description;
    @SerializedName(value="destination_field")
    protected String destinationField;
    @SerializedName(value="source_field")
    protected String sourceField;
    protected Boolean overwrite;
    protected String enrichment;
    @SerializedName(value="ignore_downstream_errors")
    protected Boolean ignoreDownstreamErrors;
    protected EnrichmentOptions options;

    protected Enrichment() {
    }

    protected Enrichment(Builder builder) {
        Validator.notNull((Object)builder.destinationField, (String)"destinationField cannot be null");
        Validator.notNull((Object)builder.sourceField, (String)"sourceField cannot be null");
        Validator.notNull((Object)builder.enrichment, (String)"enrichment cannot be null");
        this.description = builder.description;
        this.destinationField = builder.destinationField;
        this.sourceField = builder.sourceField;
        this.overwrite = builder.overwrite;
        this.enrichment = builder.enrichment;
        this.ignoreDownstreamErrors = builder.ignoreDownstreamErrors;
        this.options = builder.options;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String description() {
        return this.description;
    }

    public String destinationField() {
        return this.destinationField;
    }

    public String sourceField() {
        return this.sourceField;
    }

    public Boolean overwrite() {
        return this.overwrite;
    }

    public String enrichment() {
        return this.enrichment;
    }

    public Boolean ignoreDownstreamErrors() {
        return this.ignoreDownstreamErrors;
    }

    public EnrichmentOptions options() {
        return this.options;
    }

    public static class Builder {
        private String description;
        private String destinationField;
        private String sourceField;
        private Boolean overwrite;
        private String enrichment;
        private Boolean ignoreDownstreamErrors;
        private EnrichmentOptions options;

        private Builder(Enrichment enrichment) {
            this.description = enrichment.description;
            this.destinationField = enrichment.destinationField;
            this.sourceField = enrichment.sourceField;
            this.overwrite = enrichment.overwrite;
            this.enrichment = enrichment.enrichment;
            this.ignoreDownstreamErrors = enrichment.ignoreDownstreamErrors;
            this.options = enrichment.options;
        }

        public Builder() {
        }

        public Builder(String destinationField, String sourceField, String enrichment) {
            this.destinationField = destinationField;
            this.sourceField = sourceField;
            this.enrichment = enrichment;
        }

        public Enrichment build() {
            return new Enrichment(this);
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder destinationField(String destinationField) {
            this.destinationField = destinationField;
            return this;
        }

        public Builder sourceField(String sourceField) {
            this.sourceField = sourceField;
            return this;
        }

        public Builder overwrite(Boolean overwrite) {
            this.overwrite = overwrite;
            return this;
        }

        public Builder enrichment(String enrichment) {
            this.enrichment = enrichment;
            return this;
        }

        public Builder ignoreDownstreamErrors(Boolean ignoreDownstreamErrors) {
            this.ignoreDownstreamErrors = ignoreDownstreamErrors;
            return this;
        }

        public Builder options(EnrichmentOptions options) {
            this.options = options;
            return this;
        }
    }
}

