/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v2.model;

import com.google.gson.annotations.SerializedName;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.discovery.v2.model.ClassifierFederatedModel;
import com.ibm.watson.discovery.v2.model.DocumentClassifierEnrichment;
import java.util.ArrayList;
import java.util.List;

public class CreateDocumentClassifier
extends GenericModel {
    protected String name;
    protected String description;
    protected String language;
    @SerializedName(value="answer_field")
    protected String answerField;
    protected List<DocumentClassifierEnrichment> enrichments;
    @SerializedName(value="federated_classification")
    protected ClassifierFederatedModel federatedClassification;

    protected CreateDocumentClassifier() {
    }

    protected CreateDocumentClassifier(Builder builder) {
        Validator.notNull((Object)builder.name, (String)"name cannot be null");
        Validator.notNull((Object)builder.language, (String)"language cannot be null");
        Validator.notNull((Object)builder.answerField, (String)"answerField cannot be null");
        this.name = builder.name;
        this.description = builder.description;
        this.language = builder.language;
        this.answerField = builder.answerField;
        this.enrichments = builder.enrichments;
        this.federatedClassification = builder.federatedClassification;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String language() {
        return this.language;
    }

    public String answerField() {
        return this.answerField;
    }

    public List<DocumentClassifierEnrichment> enrichments() {
        return this.enrichments;
    }

    public ClassifierFederatedModel federatedClassification() {
        return this.federatedClassification;
    }

    public static class Builder {
        private String name;
        private String description;
        private String language;
        private String answerField;
        private List<DocumentClassifierEnrichment> enrichments;
        private ClassifierFederatedModel federatedClassification;

        private Builder(CreateDocumentClassifier createDocumentClassifier) {
            this.name = createDocumentClassifier.name;
            this.description = createDocumentClassifier.description;
            this.language = createDocumentClassifier.language;
            this.answerField = createDocumentClassifier.answerField;
            this.enrichments = createDocumentClassifier.enrichments;
            this.federatedClassification = createDocumentClassifier.federatedClassification;
        }

        public Builder() {
        }

        public Builder(String name, String language, String answerField) {
            this.name = name;
            this.language = language;
            this.answerField = answerField;
        }

        public CreateDocumentClassifier build() {
            return new CreateDocumentClassifier(this);
        }

        public Builder addEnrichments(DocumentClassifierEnrichment enrichments) {
            Validator.notNull((Object)((Object)enrichments), (String)"enrichments cannot be null");
            if (this.enrichments == null) {
                this.enrichments = new ArrayList<DocumentClassifierEnrichment>();
            }
            this.enrichments.add(enrichments);
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder language(String language) {
            this.language = language;
            return this;
        }

        public Builder answerField(String answerField) {
            this.answerField = answerField;
            return this;
        }

        public Builder enrichments(List<DocumentClassifierEnrichment> enrichments) {
            this.enrichments = enrichments;
            return this;
        }

        public Builder federatedClassification(ClassifierFederatedModel federatedClassification) {
            this.federatedClassification = federatedClassification;
            return this;
        }
    }
}

