/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v2.model;

import com.google.gson.annotations.SerializedName;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class EnrichmentOptions
extends GenericModel {
    protected List<String> languages;
    @SerializedName(value="entity_type")
    protected String entityType;
    @SerializedName(value="regular_expression")
    protected String regularExpression;
    @SerializedName(value="result_field")
    protected String resultField;
    @SerializedName(value="classifier_id")
    protected String classifierId;
    @SerializedName(value="model_id")
    protected String modelId;
    @SerializedName(value="confidence_threshold")
    protected Double confidenceThreshold;
    @SerializedName(value="top_k")
    protected Long topK;

    protected EnrichmentOptions() {
    }

    protected EnrichmentOptions(Builder builder) {
        this.languages = builder.languages;
        this.entityType = builder.entityType;
        this.regularExpression = builder.regularExpression;
        this.resultField = builder.resultField;
        this.classifierId = builder.classifierId;
        this.modelId = builder.modelId;
        this.confidenceThreshold = builder.confidenceThreshold;
        this.topK = builder.topK;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public List<String> languages() {
        return this.languages;
    }

    public String entityType() {
        return this.entityType;
    }

    public String regularExpression() {
        return this.regularExpression;
    }

    public String resultField() {
        return this.resultField;
    }

    public String classifierId() {
        return this.classifierId;
    }

    public String modelId() {
        return this.modelId;
    }

    public Double confidenceThreshold() {
        return this.confidenceThreshold;
    }

    public Long topK() {
        return this.topK;
    }

    public static class Builder {
        private List<String> languages;
        private String entityType;
        private String regularExpression;
        private String resultField;
        private String classifierId;
        private String modelId;
        private Double confidenceThreshold;
        private Long topK;

        private Builder(EnrichmentOptions enrichmentOptions) {
            this.languages = enrichmentOptions.languages;
            this.entityType = enrichmentOptions.entityType;
            this.regularExpression = enrichmentOptions.regularExpression;
            this.resultField = enrichmentOptions.resultField;
            this.classifierId = enrichmentOptions.classifierId;
            this.modelId = enrichmentOptions.modelId;
            this.confidenceThreshold = enrichmentOptions.confidenceThreshold;
            this.topK = enrichmentOptions.topK;
        }

        public Builder() {
        }

        public EnrichmentOptions build() {
            return new EnrichmentOptions(this);
        }

        public Builder addLanguages(String languages) {
            Validator.notNull((Object)languages, (String)"languages cannot be null");
            if (this.languages == null) {
                this.languages = new ArrayList<String>();
            }
            this.languages.add(languages);
            return this;
        }

        public Builder languages(List<String> languages) {
            this.languages = languages;
            return this;
        }

        public Builder entityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        public Builder regularExpression(String regularExpression) {
            this.regularExpression = regularExpression;
            return this;
        }

        public Builder resultField(String resultField) {
            this.resultField = resultField;
            return this;
        }

        public Builder classifierId(String classifierId) {
            this.classifierId = classifierId;
            return this;
        }

        public Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public Builder confidenceThreshold(Double confidenceThreshold) {
            this.confidenceThreshold = confidenceThreshold;
            return this;
        }

        public Builder topK(long topK) {
            this.topK = topK;
            return this;
        }
    }
}

