/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v2.model;

import com.google.gson.annotations.SerializedName;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.discovery.v2.model.TrainingExample;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class TrainingQuery
extends GenericModel {
    @SerializedName(value="query_id")
    protected String queryId;
    @SerializedName(value="natural_language_query")
    protected String naturalLanguageQuery;
    protected String filter;
    protected Date created;
    protected Date updated;
    protected List<TrainingExample> examples;

    protected TrainingQuery() {
    }

    protected TrainingQuery(Builder builder) {
        Validator.notNull((Object)builder.naturalLanguageQuery, (String)"naturalLanguageQuery cannot be null");
        Validator.notNull((Object)builder.examples, (String)"examples cannot be null");
        this.naturalLanguageQuery = builder.naturalLanguageQuery;
        this.filter = builder.filter;
        this.examples = builder.examples;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String queryId() {
        return this.queryId;
    }

    public String naturalLanguageQuery() {
        return this.naturalLanguageQuery;
    }

    public String filter() {
        return this.filter;
    }

    public Date created() {
        return this.created;
    }

    public Date updated() {
        return this.updated;
    }

    public List<TrainingExample> examples() {
        return this.examples;
    }

    public static class Builder {
        private String naturalLanguageQuery;
        private String filter;
        private List<TrainingExample> examples;

        private Builder(TrainingQuery trainingQuery) {
            this.naturalLanguageQuery = trainingQuery.naturalLanguageQuery;
            this.filter = trainingQuery.filter;
            this.examples = trainingQuery.examples;
        }

        public Builder() {
        }

        public Builder(String naturalLanguageQuery, List<TrainingExample> examples) {
            this.naturalLanguageQuery = naturalLanguageQuery;
            this.examples = examples;
        }

        public TrainingQuery build() {
            return new TrainingQuery(this);
        }

        public Builder addExamples(TrainingExample examples) {
            Validator.notNull((Object)((Object)examples), (String)"examples cannot be null");
            if (this.examples == null) {
                this.examples = new ArrayList<TrainingExample>();
            }
            this.examples.add(examples);
            return this;
        }

        public Builder naturalLanguageQuery(String naturalLanguageQuery) {
            this.naturalLanguageQuery = naturalLanguageQuery;
            return this;
        }

        public Builder filter(String filter) {
            this.filter = filter;
            return this;
        }

        public Builder examples(List<TrainingExample> examples) {
            this.examples = examples;
            return this;
        }
    }
}

