/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v2.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.discovery.v2.model.StopWordList;
import java.util.ArrayList;
import java.util.List;

public class CreateStopwordListOptions
extends GenericModel {
    protected String projectId;
    protected String collectionId;
    protected List<String> stopwords;

    protected CreateStopwordListOptions() {
    }

    protected CreateStopwordListOptions(Builder builder) {
        Validator.notEmpty((String)builder.projectId, (String)"projectId cannot be empty");
        Validator.notEmpty((String)builder.collectionId, (String)"collectionId cannot be empty");
        this.projectId = builder.projectId;
        this.collectionId = builder.collectionId;
        this.stopwords = builder.stopwords;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String projectId() {
        return this.projectId;
    }

    public String collectionId() {
        return this.collectionId;
    }

    public List<String> stopwords() {
        return this.stopwords;
    }

    public static class Builder {
        private String projectId;
        private String collectionId;
        private List<String> stopwords;

        private Builder(CreateStopwordListOptions createStopwordListOptions) {
            this.projectId = createStopwordListOptions.projectId;
            this.collectionId = createStopwordListOptions.collectionId;
            this.stopwords = createStopwordListOptions.stopwords;
        }

        public Builder() {
        }

        public Builder(String projectId, String collectionId) {
            this.projectId = projectId;
            this.collectionId = collectionId;
        }

        public CreateStopwordListOptions build() {
            return new CreateStopwordListOptions(this);
        }

        public Builder addStopwords(String stopwords) {
            Validator.notNull((Object)stopwords, (String)"stopwords cannot be null");
            if (this.stopwords == null) {
                this.stopwords = new ArrayList<String>();
            }
            this.stopwords.add(stopwords);
            return this;
        }

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public Builder stopwords(List<String> stopwords) {
            this.stopwords = stopwords;
            return this;
        }

        public Builder stopWordList(StopWordList stopWordList) {
            this.stopwords = stopWordList.stopwords();
            return this;
        }
    }
}

