/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v2.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;

public class GetDocumentClassifierModelOptions
extends GenericModel {
    protected String projectId;
    protected String classifierId;
    protected String modelId;

    protected GetDocumentClassifierModelOptions() {
    }

    protected GetDocumentClassifierModelOptions(Builder builder) {
        Validator.notEmpty((String)builder.projectId, (String)"projectId cannot be empty");
        Validator.notEmpty((String)builder.classifierId, (String)"classifierId cannot be empty");
        Validator.notEmpty((String)builder.modelId, (String)"modelId cannot be empty");
        this.projectId = builder.projectId;
        this.classifierId = builder.classifierId;
        this.modelId = builder.modelId;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String projectId() {
        return this.projectId;
    }

    public String classifierId() {
        return this.classifierId;
    }

    public String modelId() {
        return this.modelId;
    }

    public static class Builder {
        private String projectId;
        private String classifierId;
        private String modelId;

        private Builder(GetDocumentClassifierModelOptions getDocumentClassifierModelOptions) {
            this.projectId = getDocumentClassifierModelOptions.projectId;
            this.classifierId = getDocumentClassifierModelOptions.classifierId;
            this.modelId = getDocumentClassifierModelOptions.modelId;
        }

        public Builder() {
        }

        public Builder(String projectId, String classifierId, String modelId) {
            this.projectId = projectId;
            this.classifierId = classifierId;
            this.modelId = modelId;
        }

        public GetDocumentClassifierModelOptions build() {
            return new GetDocumentClassifierModelOptions(this);
        }

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder classifierId(String classifierId) {
            this.classifierId = classifierId;
            return this;
        }

        public Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }
    }
}

