/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v2.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;

public class QueryCollectionNoticesOptions
extends GenericModel {
    protected String projectId;
    protected String collectionId;
    protected String filter;
    protected String query;
    protected String naturalLanguageQuery;
    protected Long count;
    protected Long offset;

    protected QueryCollectionNoticesOptions() {
    }

    protected QueryCollectionNoticesOptions(Builder builder) {
        Validator.notEmpty((String)builder.projectId, (String)"projectId cannot be empty");
        Validator.notEmpty((String)builder.collectionId, (String)"collectionId cannot be empty");
        this.projectId = builder.projectId;
        this.collectionId = builder.collectionId;
        this.filter = builder.filter;
        this.query = builder.query;
        this.naturalLanguageQuery = builder.naturalLanguageQuery;
        this.count = builder.count;
        this.offset = builder.offset;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String projectId() {
        return this.projectId;
    }

    public String collectionId() {
        return this.collectionId;
    }

    public String filter() {
        return this.filter;
    }

    public String query() {
        return this.query;
    }

    public String naturalLanguageQuery() {
        return this.naturalLanguageQuery;
    }

    public Long count() {
        return this.count;
    }

    public Long offset() {
        return this.offset;
    }

    public static class Builder {
        private String projectId;
        private String collectionId;
        private String filter;
        private String query;
        private String naturalLanguageQuery;
        private Long count;
        private Long offset;

        private Builder(QueryCollectionNoticesOptions queryCollectionNoticesOptions) {
            this.projectId = queryCollectionNoticesOptions.projectId;
            this.collectionId = queryCollectionNoticesOptions.collectionId;
            this.filter = queryCollectionNoticesOptions.filter;
            this.query = queryCollectionNoticesOptions.query;
            this.naturalLanguageQuery = queryCollectionNoticesOptions.naturalLanguageQuery;
            this.count = queryCollectionNoticesOptions.count;
            this.offset = queryCollectionNoticesOptions.offset;
        }

        public Builder() {
        }

        public Builder(String projectId, String collectionId) {
            this.projectId = projectId;
            this.collectionId = collectionId;
        }

        public QueryCollectionNoticesOptions build() {
            return new QueryCollectionNoticesOptions(this);
        }

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public Builder filter(String filter) {
            this.filter = filter;
            return this;
        }

        public Builder query(String query) {
            this.query = query;
            return this;
        }

        public Builder naturalLanguageQuery(String naturalLanguageQuery) {
            this.naturalLanguageQuery = naturalLanguageQuery;
            return this;
        }

        public Builder count(long count) {
            this.count = count;
            return this;
        }

        public Builder offset(long offset) {
            this.offset = offset;
            return this;
        }
    }
}

