/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v2.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;

public class UpdateDocumentClassifierModelOptions
extends GenericModel {
    protected String projectId;
    protected String classifierId;
    protected String modelId;
    protected String name;
    protected String description;

    protected UpdateDocumentClassifierModelOptions() {
    }

    protected UpdateDocumentClassifierModelOptions(Builder builder) {
        Validator.notEmpty((String)builder.projectId, (String)"projectId cannot be empty");
        Validator.notEmpty((String)builder.classifierId, (String)"classifierId cannot be empty");
        Validator.notEmpty((String)builder.modelId, (String)"modelId cannot be empty");
        this.projectId = builder.projectId;
        this.classifierId = builder.classifierId;
        this.modelId = builder.modelId;
        this.name = builder.name;
        this.description = builder.description;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String projectId() {
        return this.projectId;
    }

    public String classifierId() {
        return this.classifierId;
    }

    public String modelId() {
        return this.modelId;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public static class Builder {
        private String projectId;
        private String classifierId;
        private String modelId;
        private String name;
        private String description;

        private Builder(UpdateDocumentClassifierModelOptions updateDocumentClassifierModelOptions) {
            this.projectId = updateDocumentClassifierModelOptions.projectId;
            this.classifierId = updateDocumentClassifierModelOptions.classifierId;
            this.modelId = updateDocumentClassifierModelOptions.modelId;
            this.name = updateDocumentClassifierModelOptions.name;
            this.description = updateDocumentClassifierModelOptions.description;
        }

        public Builder() {
        }

        public Builder(String projectId, String classifierId, String modelId) {
            this.projectId = projectId;
            this.classifierId = classifierId;
            this.modelId = modelId;
        }

        public UpdateDocumentClassifierModelOptions build() {
            return new UpdateDocumentClassifierModelOptions(this);
        }

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder classifierId(String classifierId) {
            this.classifierId = classifierId;
            return this;
        }

        public Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }
    }
}

