/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v2.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.discovery.v2.model.CollectionDetails;
import com.ibm.watson.discovery.v2.model.CollectionEnrichment;
import java.util.ArrayList;
import java.util.List;

public class CreateCollectionOptions
extends GenericModel {
    protected String projectId;
    protected String name;
    protected String description;
    protected String language;
    protected Boolean ocrEnabled;
    protected List<CollectionEnrichment> enrichments;

    protected CreateCollectionOptions() {
    }

    protected CreateCollectionOptions(Builder builder) {
        Validator.notEmpty((String)builder.projectId, (String)"projectId cannot be empty");
        Validator.notNull((Object)builder.name, (String)"name cannot be null");
        this.projectId = builder.projectId;
        this.name = builder.name;
        this.description = builder.description;
        this.language = builder.language;
        this.ocrEnabled = builder.ocrEnabled;
        this.enrichments = builder.enrichments;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String projectId() {
        return this.projectId;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String language() {
        return this.language;
    }

    public Boolean ocrEnabled() {
        return this.ocrEnabled;
    }

    public List<CollectionEnrichment> enrichments() {
        return this.enrichments;
    }

    public static class Builder {
        private String projectId;
        private String name;
        private String description;
        private String language;
        private Boolean ocrEnabled;
        private List<CollectionEnrichment> enrichments;

        private Builder(CreateCollectionOptions createCollectionOptions) {
            this.projectId = createCollectionOptions.projectId;
            this.name = createCollectionOptions.name;
            this.description = createCollectionOptions.description;
            this.language = createCollectionOptions.language;
            this.ocrEnabled = createCollectionOptions.ocrEnabled;
            this.enrichments = createCollectionOptions.enrichments;
        }

        public Builder() {
        }

        public Builder(String projectId, String name) {
            this.projectId = projectId;
            this.name = name;
        }

        public CreateCollectionOptions build() {
            return new CreateCollectionOptions(this);
        }

        public Builder addEnrichments(CollectionEnrichment enrichments) {
            Validator.notNull((Object)((Object)enrichments), (String)"enrichments cannot be null");
            if (this.enrichments == null) {
                this.enrichments = new ArrayList<CollectionEnrichment>();
            }
            this.enrichments.add(enrichments);
            return this;
        }

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder language(String language) {
            this.language = language;
            return this;
        }

        public Builder ocrEnabled(Boolean ocrEnabled) {
            this.ocrEnabled = ocrEnabled;
            return this;
        }

        public Builder enrichments(List<CollectionEnrichment> enrichments) {
            this.enrichments = enrichments;
            return this;
        }

        public Builder collectionDetails(CollectionDetails collectionDetails) {
            this.name = collectionDetails.name();
            this.description = collectionDetails.description();
            this.language = collectionDetails.language();
            this.ocrEnabled = collectionDetails.ocrEnabled();
            this.enrichments = collectionDetails.enrichments();
            return this;
        }
    }
}

