/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v2.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class CreateDocumentClassifierModelOptions
extends GenericModel {
    protected String projectId;
    protected String classifierId;
    protected String name;
    protected String description;
    protected Double learningRate;
    protected List<Double> l1RegularizationStrengths;
    protected List<Double> l2RegularizationStrengths;
    protected Long trainingMaxSteps;
    protected Double improvementRatio;

    protected CreateDocumentClassifierModelOptions() {
    }

    protected CreateDocumentClassifierModelOptions(Builder builder) {
        Validator.notEmpty((String)builder.projectId, (String)"projectId cannot be empty");
        Validator.notEmpty((String)builder.classifierId, (String)"classifierId cannot be empty");
        Validator.notNull((Object)builder.name, (String)"name cannot be null");
        this.projectId = builder.projectId;
        this.classifierId = builder.classifierId;
        this.name = builder.name;
        this.description = builder.description;
        this.learningRate = builder.learningRate;
        this.l1RegularizationStrengths = builder.l1RegularizationStrengths;
        this.l2RegularizationStrengths = builder.l2RegularizationStrengths;
        this.trainingMaxSteps = builder.trainingMaxSteps;
        this.improvementRatio = builder.improvementRatio;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String projectId() {
        return this.projectId;
    }

    public String classifierId() {
        return this.classifierId;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public Double learningRate() {
        return this.learningRate;
    }

    public List<Double> l1RegularizationStrengths() {
        return this.l1RegularizationStrengths;
    }

    public List<Double> l2RegularizationStrengths() {
        return this.l2RegularizationStrengths;
    }

    public Long trainingMaxSteps() {
        return this.trainingMaxSteps;
    }

    public Double improvementRatio() {
        return this.improvementRatio;
    }

    public static class Builder {
        private String projectId;
        private String classifierId;
        private String name;
        private String description;
        private Double learningRate;
        private List<Double> l1RegularizationStrengths;
        private List<Double> l2RegularizationStrengths;
        private Long trainingMaxSteps;
        private Double improvementRatio;

        private Builder(CreateDocumentClassifierModelOptions createDocumentClassifierModelOptions) {
            this.projectId = createDocumentClassifierModelOptions.projectId;
            this.classifierId = createDocumentClassifierModelOptions.classifierId;
            this.name = createDocumentClassifierModelOptions.name;
            this.description = createDocumentClassifierModelOptions.description;
            this.learningRate = createDocumentClassifierModelOptions.learningRate;
            this.l1RegularizationStrengths = createDocumentClassifierModelOptions.l1RegularizationStrengths;
            this.l2RegularizationStrengths = createDocumentClassifierModelOptions.l2RegularizationStrengths;
            this.trainingMaxSteps = createDocumentClassifierModelOptions.trainingMaxSteps;
            this.improvementRatio = createDocumentClassifierModelOptions.improvementRatio;
        }

        public Builder() {
        }

        public Builder(String projectId, String classifierId, String name) {
            this.projectId = projectId;
            this.classifierId = classifierId;
            this.name = name;
        }

        public CreateDocumentClassifierModelOptions build() {
            return new CreateDocumentClassifierModelOptions(this);
        }

        public Builder addL1RegularizationStrengths(Double l1RegularizationStrengths) {
            Validator.notNull((Object)l1RegularizationStrengths, (String)"l1RegularizationStrengths cannot be null");
            if (this.l1RegularizationStrengths == null) {
                this.l1RegularizationStrengths = new ArrayList<Double>();
            }
            this.l1RegularizationStrengths.add(l1RegularizationStrengths);
            return this;
        }

        public Builder addL2RegularizationStrengths(Double l2RegularizationStrengths) {
            Validator.notNull((Object)l2RegularizationStrengths, (String)"l2RegularizationStrengths cannot be null");
            if (this.l2RegularizationStrengths == null) {
                this.l2RegularizationStrengths = new ArrayList<Double>();
            }
            this.l2RegularizationStrengths.add(l2RegularizationStrengths);
            return this;
        }

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder classifierId(String classifierId) {
            this.classifierId = classifierId;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder learningRate(Double learningRate) {
            this.learningRate = learningRate;
            return this;
        }

        public Builder l1RegularizationStrengths(List<Double> l1RegularizationStrengths) {
            this.l1RegularizationStrengths = l1RegularizationStrengths;
            return this;
        }

        public Builder l2RegularizationStrengths(List<Double> l2RegularizationStrengths) {
            this.l2RegularizationStrengths = l2RegularizationStrengths;
            return this;
        }

        public Builder trainingMaxSteps(long trainingMaxSteps) {
            this.trainingMaxSteps = trainingMaxSteps;
            return this;
        }

        public Builder improvementRatio(Double improvementRatio) {
            this.improvementRatio = improvementRatio;
            return this;
        }
    }
}

