/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v2.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;

public class DeleteTrainingQueryOptions
extends GenericModel {
    protected String projectId;
    protected String queryId;

    protected DeleteTrainingQueryOptions() {
    }

    protected DeleteTrainingQueryOptions(Builder builder) {
        Validator.notEmpty((String)builder.projectId, (String)"projectId cannot be empty");
        Validator.notEmpty((String)builder.queryId, (String)"queryId cannot be empty");
        this.projectId = builder.projectId;
        this.queryId = builder.queryId;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String projectId() {
        return this.projectId;
    }

    public String queryId() {
        return this.queryId;
    }

    public static class Builder {
        private String projectId;
        private String queryId;

        private Builder(DeleteTrainingQueryOptions deleteTrainingQueryOptions) {
            this.projectId = deleteTrainingQueryOptions.projectId;
            this.queryId = deleteTrainingQueryOptions.queryId;
        }

        public Builder() {
        }

        public Builder(String projectId, String queryId) {
            this.projectId = projectId;
            this.queryId = queryId;
        }

        public DeleteTrainingQueryOptions build() {
            return new DeleteTrainingQueryOptions(this);
        }

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder queryId(String queryId) {
            this.queryId = queryId;
            return this;
        }
    }
}

