/*
 * Copyright 2018 IBM Corp. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package com.ibm.watson.discovery.v1.model;

import java.util.List;

import com.ibm.cloud.sdk.core.service.model.GenericModel;

/**
 * An object that contains an array of entities resulting from the query.
 */
public class QueryEntitiesResponse extends GenericModel {

  private List<QueryEntitiesResponseItem> entities;

  /**
   * Gets the entities.
   *
   * Array of entities that results from the query.
   *
   * @return the entities
   */
  public List<QueryEntitiesResponseItem> getEntities() {
    return entities;
  }
}
