/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.discovery.v1.model.CredentialDetails;
import com.ibm.watson.discovery.v1.model.Credentials;

public class CreateCredentialsOptions
extends GenericModel {
    private String environmentId;
    private String sourceType;
    private CredentialDetails credentialDetails;
    private String status;

    private CreateCredentialsOptions(Builder builder) {
        Validator.notEmpty((String)builder.environmentId, (String)"environmentId cannot be empty");
        this.environmentId = builder.environmentId;
        this.sourceType = builder.sourceType;
        this.credentialDetails = builder.credentialDetails;
        this.status = builder.status;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String environmentId() {
        return this.environmentId;
    }

    public String sourceType() {
        return this.sourceType;
    }

    public CredentialDetails credentialDetails() {
        return this.credentialDetails;
    }

    public String status() {
        return this.status;
    }

    public static class Builder {
        private String environmentId;
        private String sourceType;
        private CredentialDetails credentialDetails;
        private String status;

        private Builder(CreateCredentialsOptions createCredentialsOptions) {
            this.environmentId = createCredentialsOptions.environmentId;
            this.sourceType = createCredentialsOptions.sourceType;
            this.credentialDetails = createCredentialsOptions.credentialDetails;
            this.status = createCredentialsOptions.status;
        }

        public Builder() {
        }

        public Builder(String environmentId) {
            this.environmentId = environmentId;
        }

        public CreateCredentialsOptions build() {
            return new CreateCredentialsOptions(this);
        }

        public Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public Builder credentialDetails(CredentialDetails credentialDetails) {
            this.credentialDetails = credentialDetails;
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            return this;
        }

        public Builder credentials(Credentials credentials) {
            this.sourceType = credentials.getSourceType();
            this.credentialDetails = credentials.getCredentialDetails();
            this.status = credentials.getStatus();
            return this;
        }
    }

    public static interface Status {
        public static final String CONNECTED = "connected";
        public static final String INVALID = "invalid";
    }

    public static interface SourceType {
        public static final String BOX = "box";
        public static final String SALESFORCE = "salesforce";
        public static final String SHAREPOINT = "sharepoint";
        public static final String WEB_CRAWL = "web_crawl";
        public static final String CLOUD_OBJECT_STORAGE = "cloud_object_storage";
    }
}

