/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class CreateStopwordListOptions
extends GenericModel {
    private String environmentId;
    private String collectionId;
    private InputStream stopwordFile;
    private String stopwordFilename;

    private CreateStopwordListOptions(Builder builder) {
        Validator.notEmpty((String)builder.environmentId, (String)"environmentId cannot be empty");
        Validator.notEmpty((String)builder.collectionId, (String)"collectionId cannot be empty");
        Validator.notNull((Object)builder.stopwordFile, (String)"stopwordFile cannot be null");
        Validator.notNull((Object)builder.stopwordFilename, (String)"stopwordFilename cannot be null");
        this.environmentId = builder.environmentId;
        this.collectionId = builder.collectionId;
        this.stopwordFile = builder.stopwordFile;
        this.stopwordFilename = builder.stopwordFilename;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String environmentId() {
        return this.environmentId;
    }

    public String collectionId() {
        return this.collectionId;
    }

    public InputStream stopwordFile() {
        return this.stopwordFile;
    }

    public String stopwordFilename() {
        return this.stopwordFilename;
    }

    public static class Builder {
        private String environmentId;
        private String collectionId;
        private InputStream stopwordFile;
        private String stopwordFilename;

        private Builder(CreateStopwordListOptions createStopwordListOptions) {
            this.environmentId = createStopwordListOptions.environmentId;
            this.collectionId = createStopwordListOptions.collectionId;
            this.stopwordFile = createStopwordListOptions.stopwordFile;
            this.stopwordFilename = createStopwordListOptions.stopwordFilename;
        }

        public Builder() {
        }

        public Builder(String environmentId, String collectionId, InputStream stopwordFile, String stopwordFilename) {
            this.environmentId = environmentId;
            this.collectionId = collectionId;
            this.stopwordFile = stopwordFile;
            this.stopwordFilename = stopwordFilename;
        }

        public CreateStopwordListOptions build() {
            return new CreateStopwordListOptions(this);
        }

        public Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public Builder stopwordFile(InputStream stopwordFile) {
            this.stopwordFile = stopwordFile;
            return this;
        }

        public Builder stopwordFilename(String stopwordFilename) {
            this.stopwordFilename = stopwordFilename;
            return this;
        }

        public Builder stopwordFile(File stopwordFile) throws FileNotFoundException {
            this.stopwordFile = new FileInputStream(stopwordFile);
            this.stopwordFilename = stopwordFile.getName();
            return this;
        }
    }
}

