/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class FederatedQueryNoticesOptions
extends GenericModel {
    private String environmentId;
    private List<String> collectionIds;
    private String filter;
    private String query;
    private String naturalLanguageQuery;
    private String aggregation;
    private Long count;
    private List<String> returnFields;
    private Long offset;
    private List<String> sort;
    private Boolean highlight;
    private String deduplicateField;
    private Boolean similar;
    private List<String> similarDocumentIds;
    private List<String> similarFields;

    private FederatedQueryNoticesOptions(Builder builder) {
        Validator.notEmpty((String)builder.environmentId, (String)"environmentId cannot be empty");
        Validator.notNull((Object)builder.collectionIds, (String)"collectionIds cannot be null");
        this.environmentId = builder.environmentId;
        this.collectionIds = builder.collectionIds;
        this.filter = builder.filter;
        this.query = builder.query;
        this.naturalLanguageQuery = builder.naturalLanguageQuery;
        this.aggregation = builder.aggregation;
        this.count = builder.count;
        this.returnFields = builder.returnFields;
        this.offset = builder.offset;
        this.sort = builder.sort;
        this.highlight = builder.highlight;
        this.deduplicateField = builder.deduplicateField;
        this.similar = builder.similar;
        this.similarDocumentIds = builder.similarDocumentIds;
        this.similarFields = builder.similarFields;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String environmentId() {
        return this.environmentId;
    }

    public List<String> collectionIds() {
        return this.collectionIds;
    }

    public String filter() {
        return this.filter;
    }

    public String query() {
        return this.query;
    }

    public String naturalLanguageQuery() {
        return this.naturalLanguageQuery;
    }

    public String aggregation() {
        return this.aggregation;
    }

    public Long count() {
        return this.count;
    }

    public List<String> returnFields() {
        return this.returnFields;
    }

    public Long offset() {
        return this.offset;
    }

    public List<String> sort() {
        return this.sort;
    }

    public Boolean highlight() {
        return this.highlight;
    }

    public String deduplicateField() {
        return this.deduplicateField;
    }

    public Boolean similar() {
        return this.similar;
    }

    public List<String> similarDocumentIds() {
        return this.similarDocumentIds;
    }

    public List<String> similarFields() {
        return this.similarFields;
    }

    public static class Builder {
        private String environmentId;
        private List<String> collectionIds;
        private String filter;
        private String query;
        private String naturalLanguageQuery;
        private String aggregation;
        private Long count;
        private List<String> returnFields;
        private Long offset;
        private List<String> sort;
        private Boolean highlight;
        private String deduplicateField;
        private Boolean similar;
        private List<String> similarDocumentIds;
        private List<String> similarFields;

        private Builder(FederatedQueryNoticesOptions federatedQueryNoticesOptions) {
            this.environmentId = federatedQueryNoticesOptions.environmentId;
            this.collectionIds = federatedQueryNoticesOptions.collectionIds;
            this.filter = federatedQueryNoticesOptions.filter;
            this.query = federatedQueryNoticesOptions.query;
            this.naturalLanguageQuery = federatedQueryNoticesOptions.naturalLanguageQuery;
            this.aggregation = federatedQueryNoticesOptions.aggregation;
            this.count = federatedQueryNoticesOptions.count;
            this.returnFields = federatedQueryNoticesOptions.returnFields;
            this.offset = federatedQueryNoticesOptions.offset;
            this.sort = federatedQueryNoticesOptions.sort;
            this.highlight = federatedQueryNoticesOptions.highlight;
            this.deduplicateField = federatedQueryNoticesOptions.deduplicateField;
            this.similar = federatedQueryNoticesOptions.similar;
            this.similarDocumentIds = federatedQueryNoticesOptions.similarDocumentIds;
            this.similarFields = federatedQueryNoticesOptions.similarFields;
        }

        public Builder() {
        }

        public Builder(String environmentId, List<String> collectionIds) {
            this.environmentId = environmentId;
            this.collectionIds = collectionIds;
        }

        public FederatedQueryNoticesOptions build() {
            return new FederatedQueryNoticesOptions(this);
        }

        public Builder addCollectionIds(String collectionIds) {
            Validator.notNull((Object)collectionIds, (String)"collectionIds cannot be null");
            if (this.collectionIds == null) {
                this.collectionIds = new ArrayList<String>();
            }
            this.collectionIds.add(collectionIds);
            return this;
        }

        public Builder addReturnField(String returnField) {
            Validator.notNull((Object)returnField, (String)"returnField cannot be null");
            if (this.returnFields == null) {
                this.returnFields = new ArrayList<String>();
            }
            this.returnFields.add(returnField);
            return this;
        }

        public Builder addSort(String sort) {
            Validator.notNull((Object)sort, (String)"sort cannot be null");
            if (this.sort == null) {
                this.sort = new ArrayList<String>();
            }
            this.sort.add(sort);
            return this;
        }

        public Builder addSimilarDocumentIds(String similarDocumentIds) {
            Validator.notNull((Object)similarDocumentIds, (String)"similarDocumentIds cannot be null");
            if (this.similarDocumentIds == null) {
                this.similarDocumentIds = new ArrayList<String>();
            }
            this.similarDocumentIds.add(similarDocumentIds);
            return this;
        }

        public Builder addSimilarFields(String similarFields) {
            Validator.notNull((Object)similarFields, (String)"similarFields cannot be null");
            if (this.similarFields == null) {
                this.similarFields = new ArrayList<String>();
            }
            this.similarFields.add(similarFields);
            return this;
        }

        public Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public Builder collectionIds(List<String> collectionIds) {
            this.collectionIds = collectionIds;
            return this;
        }

        public Builder filter(String filter) {
            this.filter = filter;
            return this;
        }

        public Builder query(String query) {
            this.query = query;
            return this;
        }

        public Builder naturalLanguageQuery(String naturalLanguageQuery) {
            this.naturalLanguageQuery = naturalLanguageQuery;
            return this;
        }

        public Builder aggregation(String aggregation) {
            this.aggregation = aggregation;
            return this;
        }

        public Builder count(long count) {
            this.count = count;
            return this;
        }

        public Builder returnFields(List<String> returnFields) {
            this.returnFields = returnFields;
            return this;
        }

        public Builder offset(long offset) {
            this.offset = offset;
            return this;
        }

        public Builder sort(List<String> sort) {
            this.sort = sort;
            return this;
        }

        public Builder highlight(Boolean highlight) {
            this.highlight = highlight;
            return this;
        }

        public Builder deduplicateField(String deduplicateField) {
            this.deduplicateField = deduplicateField;
            return this;
        }

        public Builder similar(Boolean similar) {
            this.similar = similar;
            return this;
        }

        public Builder similarDocumentIds(List<String> similarDocumentIds) {
            this.similarDocumentIds = similarDocumentIds;
            return this;
        }

        public Builder similarFields(List<String> similarFields) {
            this.similarFields = similarFields;
            return this;
        }
    }
}

