/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v1;

import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.ibm.cloud.sdk.core.http.RequestBuilder;
import com.ibm.cloud.sdk.core.http.ResponseConverter;
import com.ibm.cloud.sdk.core.http.ServiceCall;
import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.security.ConfigBasedAuthenticatorFactory;
import com.ibm.cloud.sdk.core.service.BaseService;
import com.ibm.cloud.sdk.core.util.GsonSingleton;
import com.ibm.cloud.sdk.core.util.RequestUtils;
import com.ibm.cloud.sdk.core.util.ResponseConverterUtils;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.common.SdkCommon;
import com.ibm.watson.discovery.v1.model.AddDocumentOptions;
import com.ibm.watson.discovery.v1.model.AddTrainingDataOptions;
import com.ibm.watson.discovery.v1.model.Collection;
import com.ibm.watson.discovery.v1.model.Completions;
import com.ibm.watson.discovery.v1.model.Configuration;
import com.ibm.watson.discovery.v1.model.CreateCollectionOptions;
import com.ibm.watson.discovery.v1.model.CreateConfigurationOptions;
import com.ibm.watson.discovery.v1.model.CreateCredentialsOptions;
import com.ibm.watson.discovery.v1.model.CreateEnvironmentOptions;
import com.ibm.watson.discovery.v1.model.CreateEventOptions;
import com.ibm.watson.discovery.v1.model.CreateEventResponse;
import com.ibm.watson.discovery.v1.model.CreateExpansionsOptions;
import com.ibm.watson.discovery.v1.model.CreateGatewayOptions;
import com.ibm.watson.discovery.v1.model.CreateStopwordListOptions;
import com.ibm.watson.discovery.v1.model.CreateTokenizationDictionaryOptions;
import com.ibm.watson.discovery.v1.model.CreateTrainingExampleOptions;
import com.ibm.watson.discovery.v1.model.Credentials;
import com.ibm.watson.discovery.v1.model.CredentialsList;
import com.ibm.watson.discovery.v1.model.DeleteAllTrainingDataOptions;
import com.ibm.watson.discovery.v1.model.DeleteCollectionOptions;
import com.ibm.watson.discovery.v1.model.DeleteCollectionResponse;
import com.ibm.watson.discovery.v1.model.DeleteConfigurationOptions;
import com.ibm.watson.discovery.v1.model.DeleteConfigurationResponse;
import com.ibm.watson.discovery.v1.model.DeleteCredentials;
import com.ibm.watson.discovery.v1.model.DeleteCredentialsOptions;
import com.ibm.watson.discovery.v1.model.DeleteDocumentOptions;
import com.ibm.watson.discovery.v1.model.DeleteDocumentResponse;
import com.ibm.watson.discovery.v1.model.DeleteEnvironmentOptions;
import com.ibm.watson.discovery.v1.model.DeleteEnvironmentResponse;
import com.ibm.watson.discovery.v1.model.DeleteExpansionsOptions;
import com.ibm.watson.discovery.v1.model.DeleteGatewayOptions;
import com.ibm.watson.discovery.v1.model.DeleteStopwordListOptions;
import com.ibm.watson.discovery.v1.model.DeleteTokenizationDictionaryOptions;
import com.ibm.watson.discovery.v1.model.DeleteTrainingDataOptions;
import com.ibm.watson.discovery.v1.model.DeleteTrainingExampleOptions;
import com.ibm.watson.discovery.v1.model.DeleteUserDataOptions;
import com.ibm.watson.discovery.v1.model.DocumentAccepted;
import com.ibm.watson.discovery.v1.model.DocumentStatus;
import com.ibm.watson.discovery.v1.model.Environment;
import com.ibm.watson.discovery.v1.model.Expansions;
import com.ibm.watson.discovery.v1.model.FederatedQueryNoticesOptions;
import com.ibm.watson.discovery.v1.model.FederatedQueryOptions;
import com.ibm.watson.discovery.v1.model.Gateway;
import com.ibm.watson.discovery.v1.model.GatewayDelete;
import com.ibm.watson.discovery.v1.model.GatewayList;
import com.ibm.watson.discovery.v1.model.GetAutocompletionOptions;
import com.ibm.watson.discovery.v1.model.GetCollectionOptions;
import com.ibm.watson.discovery.v1.model.GetConfigurationOptions;
import com.ibm.watson.discovery.v1.model.GetCredentialsOptions;
import com.ibm.watson.discovery.v1.model.GetDocumentStatusOptions;
import com.ibm.watson.discovery.v1.model.GetEnvironmentOptions;
import com.ibm.watson.discovery.v1.model.GetGatewayOptions;
import com.ibm.watson.discovery.v1.model.GetMetricsEventRateOptions;
import com.ibm.watson.discovery.v1.model.GetMetricsQueryEventOptions;
import com.ibm.watson.discovery.v1.model.GetMetricsQueryNoResultsOptions;
import com.ibm.watson.discovery.v1.model.GetMetricsQueryOptions;
import com.ibm.watson.discovery.v1.model.GetMetricsQueryTokenEventOptions;
import com.ibm.watson.discovery.v1.model.GetStopwordListStatusOptions;
import com.ibm.watson.discovery.v1.model.GetTokenizationDictionaryStatusOptions;
import com.ibm.watson.discovery.v1.model.GetTrainingDataOptions;
import com.ibm.watson.discovery.v1.model.GetTrainingExampleOptions;
import com.ibm.watson.discovery.v1.model.ListCollectionFieldsOptions;
import com.ibm.watson.discovery.v1.model.ListCollectionFieldsResponse;
import com.ibm.watson.discovery.v1.model.ListCollectionsOptions;
import com.ibm.watson.discovery.v1.model.ListCollectionsResponse;
import com.ibm.watson.discovery.v1.model.ListConfigurationsOptions;
import com.ibm.watson.discovery.v1.model.ListConfigurationsResponse;
import com.ibm.watson.discovery.v1.model.ListCredentialsOptions;
import com.ibm.watson.discovery.v1.model.ListEnvironmentsOptions;
import com.ibm.watson.discovery.v1.model.ListEnvironmentsResponse;
import com.ibm.watson.discovery.v1.model.ListExpansionsOptions;
import com.ibm.watson.discovery.v1.model.ListFieldsOptions;
import com.ibm.watson.discovery.v1.model.ListGatewaysOptions;
import com.ibm.watson.discovery.v1.model.ListTrainingDataOptions;
import com.ibm.watson.discovery.v1.model.ListTrainingExamplesOptions;
import com.ibm.watson.discovery.v1.model.LogQueryResponse;
import com.ibm.watson.discovery.v1.model.MetricResponse;
import com.ibm.watson.discovery.v1.model.MetricTokenResponse;
import com.ibm.watson.discovery.v1.model.QueryLogOptions;
import com.ibm.watson.discovery.v1.model.QueryNoticesOptions;
import com.ibm.watson.discovery.v1.model.QueryNoticesResponse;
import com.ibm.watson.discovery.v1.model.QueryOptions;
import com.ibm.watson.discovery.v1.model.QueryResponse;
import com.ibm.watson.discovery.v1.model.TokenDictStatusResponse;
import com.ibm.watson.discovery.v1.model.TrainingDataSet;
import com.ibm.watson.discovery.v1.model.TrainingExample;
import com.ibm.watson.discovery.v1.model.TrainingExampleList;
import com.ibm.watson.discovery.v1.model.TrainingQuery;
import com.ibm.watson.discovery.v1.model.UpdateCollectionOptions;
import com.ibm.watson.discovery.v1.model.UpdateConfigurationOptions;
import com.ibm.watson.discovery.v1.model.UpdateCredentialsOptions;
import com.ibm.watson.discovery.v1.model.UpdateDocumentOptions;
import com.ibm.watson.discovery.v1.model.UpdateEnvironmentOptions;
import com.ibm.watson.discovery.v1.model.UpdateTrainingExampleOptions;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Map;
import okhttp3.HttpUrl;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;

public class Discovery
extends BaseService {
    private static final String SERVICE_NAME = "discovery";
    private static final String SERVICE_URL = "https://gateway.watsonplatform.net/discovery/api";
    private String versionDate;

    public Discovery(String versionDate) {
        this(versionDate, ConfigBasedAuthenticatorFactory.getAuthenticator((String)SERVICE_NAME));
    }

    public Discovery(String versionDate, Authenticator authenticator) {
        super(SERVICE_NAME, authenticator);
        if (this.getServiceUrl() == null || this.getServiceUrl().isEmpty()) {
            this.setServiceUrl(SERVICE_URL);
        }
        Validator.isTrue((versionDate != null && !versionDate.isEmpty() ? 1 : 0) != 0, (String)"version cannot be null.");
        this.versionDate = versionDate;
    }

    public ServiceCall<Environment> createEnvironment(CreateEnvironmentOptions createEnvironmentOptions) {
        Validator.notNull((Object)((Object)createEnvironmentOptions), (String)"createEnvironmentOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments"};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v1", (String)"createEnvironment");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("name", createEnvironmentOptions.name());
        if (createEnvironmentOptions.description() != null) {
            contentJson.addProperty("description", createEnvironmentOptions.description());
        }
        if (createEnvironmentOptions.size() != null) {
            contentJson.addProperty("size", createEnvironmentOptions.size());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Environment>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ListEnvironmentsResponse> listEnvironments(ListEnvironmentsOptions listEnvironmentsOptions) {
        String[] pathSegments = new String[]{"v1/environments"};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v1", (String)"listEnvironments");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (listEnvironmentsOptions != null && listEnvironmentsOptions.name() != null) {
            builder.query(new Object[]{"name", listEnvironmentsOptions.name()});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ListEnvironmentsResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ListEnvironmentsResponse> listEnvironments() {
        return this.listEnvironments(null);
    }

    public ServiceCall<Environment> getEnvironment(GetEnvironmentOptions getEnvironmentOptions) {
        Validator.notNull((Object)((Object)getEnvironmentOptions), (String)"getEnvironmentOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments"};
        String[] pathParameters = new String[]{getEnvironmentOptions.environmentId()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v1", (String)"getEnvironment");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Environment>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Environment> updateEnvironment(UpdateEnvironmentOptions updateEnvironmentOptions) {
        Validator.notNull((Object)((Object)updateEnvironmentOptions), (String)"updateEnvironmentOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments"};
        String[] pathParameters = new String[]{updateEnvironmentOptions.environmentId()};
        RequestBuilder builder = RequestBuilder.put((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v1", (String)"updateEnvironment");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        if (updateEnvironmentOptions.name() != null) {
            contentJson.addProperty("name", updateEnvironmentOptions.name());
        }
        if (updateEnvironmentOptions.description() != null) {
            contentJson.addProperty("description", updateEnvironmentOptions.description());
        }
        if (updateEnvironmentOptions.size() != null) {
            contentJson.addProperty("size", updateEnvironmentOptions.size());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Environment>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<DeleteEnvironmentResponse> deleteEnvironment(DeleteEnvironmentOptions deleteEnvironmentOptions) {
        Validator.notNull((Object)((Object)deleteEnvironmentOptions), (String)"deleteEnvironmentOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments"};
        String[] pathParameters = new String[]{deleteEnvironmentOptions.environmentId()};
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v1", (String)"deleteEnvironment");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<DeleteEnvironmentResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ListCollectionFieldsResponse> listFields(ListFieldsOptions listFieldsOptions) {
        Validator.notNull((Object)((Object)listFieldsOptions), (String)"listFieldsOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "fields"};
        String[] pathParameters = new String[]{listFieldsOptions.environmentId()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v1", (String)"listFields");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"collection_ids", RequestUtils.join(listFieldsOptions.collectionIds(), (String)",")});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ListCollectionFieldsResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Configuration> createConfiguration(CreateConfigurationOptions createConfigurationOptions) {
        Validator.notNull((Object)((Object)createConfigurationOptions), (String)"createConfigurationOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "configurations"};
        String[] pathParameters = new String[]{createConfigurationOptions.environmentId()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v1", (String)"createConfiguration");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("name", createConfigurationOptions.name());
        if (createConfigurationOptions.description() != null) {
            contentJson.addProperty("description", createConfigurationOptions.description());
        }
        if (createConfigurationOptions.conversions() != null) {
            contentJson.add("conversions", GsonSingleton.getGson().toJsonTree((Object)createConfigurationOptions.conversions()));
        }
        if (createConfigurationOptions.enrichments() != null) {
            contentJson.add("enrichments", GsonSingleton.getGson().toJsonTree(createConfigurationOptions.enrichments()));
        }
        if (createConfigurationOptions.normalizations() != null) {
            contentJson.add("normalizations", GsonSingleton.getGson().toJsonTree(createConfigurationOptions.normalizations()));
        }
        if (createConfigurationOptions.source() != null) {
            contentJson.add("source", GsonSingleton.getGson().toJsonTree((Object)createConfigurationOptions.source()));
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Configuration>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ListConfigurationsResponse> listConfigurations(ListConfigurationsOptions listConfigurationsOptions) {
        Validator.notNull((Object)((Object)listConfigurationsOptions), (String)"listConfigurationsOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "configurations"};
        String[] pathParameters = new String[]{listConfigurationsOptions.environmentId()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v1", (String)"listConfigurations");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (listConfigurationsOptions.name() != null) {
            builder.query(new Object[]{"name", listConfigurationsOptions.name()});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ListConfigurationsResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Configuration> getConfiguration(GetConfigurationOptions getConfigurationOptions) {
        Validator.notNull((Object)((Object)getConfigurationOptions), (String)"getConfigurationOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "configurations"};
        String[] pathParameters = new String[]{getConfigurationOptions.environmentId(), getConfigurationOptions.configurationId()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v1", (String)"getConfiguration");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Configuration>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Configuration> updateConfiguration(UpdateConfigurationOptions updateConfigurationOptions) {
        Validator.notNull((Object)((Object)updateConfigurationOptions), (String)"updateConfigurationOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "configurations"};
        String[] pathParameters = new String[]{updateConfigurationOptions.environmentId(), updateConfigurationOptions.configurationId()};
        RequestBuilder builder = RequestBuilder.put((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v1", (String)"updateConfiguration");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("name", updateConfigurationOptions.name());
        if (updateConfigurationOptions.description() != null) {
            contentJson.addProperty("description", updateConfigurationOptions.description());
        }
        if (updateConfigurationOptions.conversions() != null) {
            contentJson.add("conversions", GsonSingleton.getGson().toJsonTree((Object)updateConfigurationOptions.conversions()));
        }
        if (updateConfigurationOptions.enrichments() != null) {
            contentJson.add("enrichments", GsonSingleton.getGson().toJsonTree(updateConfigurationOptions.enrichments()));
        }
        if (updateConfigurationOptions.normalizations() != null) {
            contentJson.add("normalizations", GsonSingleton.getGson().toJsonTree(updateConfigurationOptions.normalizations()));
        }
        if (updateConfigurationOptions.source() != null) {
            contentJson.add("source", GsonSingleton.getGson().toJsonTree((Object)updateConfigurationOptions.source()));
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Configuration>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<DeleteConfigurationResponse> deleteConfiguration(DeleteConfigurationOptions deleteConfigurationOptions) {
        Validator.notNull((Object)((Object)deleteConfigurationOptions), (String)"deleteConfigurationOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "configurations"};
        String[] pathParameters = new String[]{deleteConfigurationOptions.environmentId(), deleteConfigurationOptions.configurationId()};
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v1", (String)"deleteConfiguration");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<DeleteConfigurationResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Collection> createCollection(CreateCollectionOptions createCollectionOptions) {
        Validator.notNull((Object)((Object)createCollectionOptions), (String)"createCollectionOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "collections"};
        String[] pathParameters = new String[]{createCollectionOptions.environmentId()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v1", (String)"createCollection");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("name", createCollectionOptions.name());
        if (createCollectionOptions.description() != null) {
            contentJson.addProperty("description", createCollectionOptions.description());
        }
        if (createCollectionOptions.configurationId() != null) {
            contentJson.addProperty("configuration_id", createCollectionOptions.configurationId());
        }
        if (createCollectionOptions.language() != null) {
            contentJson.addProperty("language", createCollectionOptions.language());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Collection>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ListCollectionsResponse> listCollections(ListCollectionsOptions listCollectionsOptions) {
        Validator.notNull((Object)((Object)listCollectionsOptions), (String)"listCollectionsOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "collections"};
        String[] pathParameters = new String[]{listCollectionsOptions.environmentId()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v1", (String)"listCollections");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (listCollectionsOptions.name() != null) {
            builder.query(new Object[]{"name", listCollectionsOptions.name()});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ListCollectionsResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Collection> getCollection(GetCollectionOptions getCollectionOptions) {
        Validator.notNull((Object)((Object)getCollectionOptions), (String)"getCollectionOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "collections"};
        String[] pathParameters = new String[]{getCollectionOptions.environmentId(), getCollectionOptions.collectionId()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v1", (String)"getCollection");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Collection>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Collection> updateCollection(UpdateCollectionOptions updateCollectionOptions) {
        Validator.notNull((Object)((Object)updateCollectionOptions), (String)"updateCollectionOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "collections"};
        String[] pathParameters = new String[]{updateCollectionOptions.environmentId(), updateCollectionOptions.collectionId()};
        RequestBuilder builder = RequestBuilder.put((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v1", (String)"updateCollection");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        if (updateCollectionOptions.name() != null) {
            contentJson.addProperty("name", updateCollectionOptions.name());
        }
        if (updateCollectionOptions.description() != null) {
            contentJson.addProperty("description", updateCollectionOptions.description());
        }
        if (updateCollectionOptions.configurationId() != null) {
            contentJson.addProperty("configuration_id", updateCollectionOptions.configurationId());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Collection>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<DeleteCollectionResponse> deleteCollection(DeleteCollectionOptions deleteCollectionOptions) {
        Validator.notNull((Object)((Object)deleteCollectionOptions), (String)"deleteCollectionOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "collections"};
        String[] pathParameters = new String[]{deleteCollectionOptions.environmentId(), deleteCollectionOptions.collectionId()};
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v1", (String)"deleteCollection");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<DeleteCollectionResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ListCollectionFieldsResponse> listCollectionFields(ListCollectionFieldsOptions listCollectionFieldsOptions) {
        Validator.notNull((Object)((Object)listCollectionFieldsOptions), (String)"listCollectionFieldsOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "collections", "fields"};
        String[] pathParameters = new String[]{listCollectionFieldsOptions.environmentId(), listCollectionFieldsOptions.collectionId()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v1", (String)"listCollectionFields");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ListCollectionFieldsResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Expansions> listExpansions(ListExpansionsOptions listExpansionsOptions) {
        Validator.notNull((Object)((Object)listExpansionsOptions), (String)"listExpansionsOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "collections", "expansions"};
        String[] pathParameters = new String[]{listExpansionsOptions.environmentId(), listExpansionsOptions.collectionId()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v1", (String)"listExpansions");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Expansions>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Expansions> createExpansions(CreateExpansionsOptions createExpansionsOptions) {
        Validator.notNull((Object)((Object)createExpansionsOptions), (String)"createExpansionsOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "collections", "expansions"};
        String[] pathParameters = new String[]{createExpansionsOptions.environmentId(), createExpansionsOptions.collectionId()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v1", (String)"createExpansions");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        contentJson.add("expansions", GsonSingleton.getGson().toJsonTree(createExpansionsOptions.expansions()));
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Expansions>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteExpansions(DeleteExpansionsOptions deleteExpansionsOptions) {
        Validator.notNull((Object)((Object)deleteExpansionsOptions), (String)"deleteExpansionsOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "collections", "expansions"};
        String[] pathParameters = new String[]{deleteExpansionsOptions.environmentId(), deleteExpansionsOptions.collectionId()};
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v1", (String)"deleteExpansions");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<TokenDictStatusResponse> getTokenizationDictionaryStatus(GetTokenizationDictionaryStatusOptions getTokenizationDictionaryStatusOptions) {
        Validator.notNull((Object)((Object)getTokenizationDictionaryStatusOptions), (String)"getTokenizationDictionaryStatusOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "collections", "word_lists/tokenization_dictionary"};
        String[] pathParameters = new String[]{getTokenizationDictionaryStatusOptions.environmentId(), getTokenizationDictionaryStatusOptions.collectionId()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v1", (String)"getTokenizationDictionaryStatus");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<TokenDictStatusResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<TokenDictStatusResponse> createTokenizationDictionary(CreateTokenizationDictionaryOptions createTokenizationDictionaryOptions) {
        Validator.notNull((Object)((Object)createTokenizationDictionaryOptions), (String)"createTokenizationDictionaryOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "collections", "word_lists/tokenization_dictionary"};
        String[] pathParameters = new String[]{createTokenizationDictionaryOptions.environmentId(), createTokenizationDictionaryOptions.collectionId()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v1", (String)"createTokenizationDictionary");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        if (createTokenizationDictionaryOptions.tokenizationRules() != null) {
            contentJson.add("tokenization_rules", GsonSingleton.getGson().toJsonTree(createTokenizationDictionaryOptions.tokenizationRules()));
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<TokenDictStatusResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteTokenizationDictionary(DeleteTokenizationDictionaryOptions deleteTokenizationDictionaryOptions) {
        Validator.notNull((Object)((Object)deleteTokenizationDictionaryOptions), (String)"deleteTokenizationDictionaryOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "collections", "word_lists/tokenization_dictionary"};
        String[] pathParameters = new String[]{deleteTokenizationDictionaryOptions.environmentId(), deleteTokenizationDictionaryOptions.collectionId()};
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v1", (String)"deleteTokenizationDictionary");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<TokenDictStatusResponse> getStopwordListStatus(GetStopwordListStatusOptions getStopwordListStatusOptions) {
        Validator.notNull((Object)((Object)getStopwordListStatusOptions), (String)"getStopwordListStatusOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "collections", "word_lists/stopwords"};
        String[] pathParameters = new String[]{getStopwordListStatusOptions.environmentId(), getStopwordListStatusOptions.collectionId()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v1", (String)"getStopwordListStatus");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<TokenDictStatusResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<TokenDictStatusResponse> createStopwordList(CreateStopwordListOptions createStopwordListOptions) {
        Validator.notNull((Object)((Object)createStopwordListOptions), (String)"createStopwordListOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "collections", "word_lists/stopwords"};
        String[] pathParameters = new String[]{createStopwordListOptions.environmentId(), createStopwordListOptions.collectionId()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v1", (String)"createStopwordList");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        MultipartBody.Builder multipartBuilder = new MultipartBody.Builder();
        multipartBuilder.setType(MultipartBody.FORM);
        RequestBody stopwordFileBody = RequestUtils.inputStreamBody((InputStream)createStopwordListOptions.stopwordFile(), (String)"application/octet-stream");
        multipartBuilder.addFormDataPart("stopword_file", createStopwordListOptions.stopwordFilename(), stopwordFileBody);
        builder.body((RequestBody)multipartBuilder.build());
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<TokenDictStatusResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteStopwordList(DeleteStopwordListOptions deleteStopwordListOptions) {
        Validator.notNull((Object)((Object)deleteStopwordListOptions), (String)"deleteStopwordListOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "collections", "word_lists/stopwords"};
        String[] pathParameters = new String[]{deleteStopwordListOptions.environmentId(), deleteStopwordListOptions.collectionId()};
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v1", (String)"deleteStopwordList");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<DocumentAccepted> addDocument(AddDocumentOptions addDocumentOptions) {
        Validator.notNull((Object)((Object)addDocumentOptions), (String)"addDocumentOptions cannot be null");
        Validator.isTrue((addDocumentOptions.file() != null || addDocumentOptions.metadata() != null ? 1 : 0) != 0, (String)"At least one of file or metadata must be supplied.");
        String[] pathSegments = new String[]{"v1/environments", "collections", "documents"};
        String[] pathParameters = new String[]{addDocumentOptions.environmentId(), addDocumentOptions.collectionId()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v1", (String)"addDocument");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        MultipartBody.Builder multipartBuilder = new MultipartBody.Builder();
        multipartBuilder.setType(MultipartBody.FORM);
        if (addDocumentOptions.file() != null) {
            RequestBody fileBody = RequestUtils.inputStreamBody((InputStream)addDocumentOptions.file(), (String)addDocumentOptions.fileContentType());
            multipartBuilder.addFormDataPart("file", addDocumentOptions.filename(), fileBody);
        }
        if (addDocumentOptions.metadata() != null) {
            multipartBuilder.addFormDataPart("metadata", addDocumentOptions.metadata());
        }
        builder.body((RequestBody)multipartBuilder.build());
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<DocumentAccepted>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<DocumentStatus> getDocumentStatus(GetDocumentStatusOptions getDocumentStatusOptions) {
        Validator.notNull((Object)((Object)getDocumentStatusOptions), (String)"getDocumentStatusOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "collections", "documents"};
        String[] pathParameters = new String[]{getDocumentStatusOptions.environmentId(), getDocumentStatusOptions.collectionId(), getDocumentStatusOptions.documentId()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v1", (String)"getDocumentStatus");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<DocumentStatus>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<DocumentAccepted> updateDocument(UpdateDocumentOptions updateDocumentOptions) {
        Validator.notNull((Object)((Object)updateDocumentOptions), (String)"updateDocumentOptions cannot be null");
        Validator.isTrue((updateDocumentOptions.file() != null || updateDocumentOptions.metadata() != null ? 1 : 0) != 0, (String)"At least one of file or metadata must be supplied.");
        String[] pathSegments = new String[]{"v1/environments", "collections", "documents"};
        String[] pathParameters = new String[]{updateDocumentOptions.environmentId(), updateDocumentOptions.collectionId(), updateDocumentOptions.documentId()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v1", (String)"updateDocument");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        MultipartBody.Builder multipartBuilder = new MultipartBody.Builder();
        multipartBuilder.setType(MultipartBody.FORM);
        if (updateDocumentOptions.file() != null) {
            RequestBody fileBody = RequestUtils.inputStreamBody((InputStream)updateDocumentOptions.file(), (String)updateDocumentOptions.fileContentType());
            multipartBuilder.addFormDataPart("file", updateDocumentOptions.filename(), fileBody);
        }
        if (updateDocumentOptions.metadata() != null) {
            multipartBuilder.addFormDataPart("metadata", updateDocumentOptions.metadata());
        }
        builder.body((RequestBody)multipartBuilder.build());
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<DocumentAccepted>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<DeleteDocumentResponse> deleteDocument(DeleteDocumentOptions deleteDocumentOptions) {
        Validator.notNull((Object)((Object)deleteDocumentOptions), (String)"deleteDocumentOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "collections", "documents"};
        String[] pathParameters = new String[]{deleteDocumentOptions.environmentId(), deleteDocumentOptions.collectionId(), deleteDocumentOptions.documentId()};
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v1", (String)"deleteDocument");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<DeleteDocumentResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<QueryResponse> query(QueryOptions queryOptions) {
        Validator.notNull((Object)((Object)queryOptions), (String)"queryOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "collections", "query"};
        String[] pathParameters = new String[]{queryOptions.environmentId(), queryOptions.collectionId()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v1", (String)"query");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (queryOptions.xWatsonLoggingOptOut() != null) {
            builder.header(new Object[]{"X-Watson-Logging-Opt-Out", queryOptions.xWatsonLoggingOptOut()});
        }
        JsonObject contentJson = new JsonObject();
        if (queryOptions.filter() != null) {
            contentJson.addProperty("filter", queryOptions.filter());
        }
        if (queryOptions.query() != null) {
            contentJson.addProperty("query", queryOptions.query());
        }
        if (queryOptions.naturalLanguageQuery() != null) {
            contentJson.addProperty("natural_language_query", queryOptions.naturalLanguageQuery());
        }
        if (queryOptions.passages() != null) {
            contentJson.addProperty("passages", queryOptions.passages());
        }
        if (queryOptions.aggregation() != null) {
            contentJson.addProperty("aggregation", queryOptions.aggregation());
        }
        if (queryOptions.count() != null) {
            contentJson.addProperty("count", (Number)queryOptions.count());
        }
        if (queryOptions.xReturn() != null) {
            contentJson.addProperty("return", queryOptions.xReturn());
        }
        if (queryOptions.offset() != null) {
            contentJson.addProperty("offset", (Number)queryOptions.offset());
        }
        if (queryOptions.sort() != null) {
            contentJson.addProperty("sort", queryOptions.sort());
        }
        if (queryOptions.highlight() != null) {
            contentJson.addProperty("highlight", queryOptions.highlight());
        }
        if (queryOptions.passagesFields() != null) {
            contentJson.addProperty("passages.fields", queryOptions.passagesFields());
        }
        if (queryOptions.passagesCount() != null) {
            contentJson.addProperty("passages.count", (Number)queryOptions.passagesCount());
        }
        if (queryOptions.passagesCharacters() != null) {
            contentJson.addProperty("passages.characters", (Number)queryOptions.passagesCharacters());
        }
        if (queryOptions.deduplicate() != null) {
            contentJson.addProperty("deduplicate", queryOptions.deduplicate());
        }
        if (queryOptions.deduplicateField() != null) {
            contentJson.addProperty("deduplicate.field", queryOptions.deduplicateField());
        }
        if (queryOptions.similar() != null) {
            contentJson.addProperty("similar", queryOptions.similar());
        }
        if (queryOptions.similarDocumentIds() != null) {
            contentJson.addProperty("similar.document_ids", queryOptions.similarDocumentIds());
        }
        if (queryOptions.similarFields() != null) {
            contentJson.addProperty("similar.fields", queryOptions.similarFields());
        }
        if (queryOptions.bias() != null) {
            contentJson.addProperty("bias", queryOptions.bias());
        }
        if (queryOptions.spellingSuggestions() != null) {
            contentJson.addProperty("spelling_suggestions", queryOptions.spellingSuggestions());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<QueryResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<QueryNoticesResponse> queryNotices(QueryNoticesOptions queryNoticesOptions) {
        Validator.notNull((Object)((Object)queryNoticesOptions), (String)"queryNoticesOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "collections", "notices"};
        String[] pathParameters = new String[]{queryNoticesOptions.environmentId(), queryNoticesOptions.collectionId()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v1", (String)"queryNotices");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (queryNoticesOptions.filter() != null) {
            builder.query(new Object[]{"filter", queryNoticesOptions.filter()});
        }
        if (queryNoticesOptions.query() != null) {
            builder.query(new Object[]{"query", queryNoticesOptions.query()});
        }
        if (queryNoticesOptions.naturalLanguageQuery() != null) {
            builder.query(new Object[]{"natural_language_query", queryNoticesOptions.naturalLanguageQuery()});
        }
        if (queryNoticesOptions.passages() != null) {
            builder.query(new Object[]{"passages", String.valueOf(queryNoticesOptions.passages())});
        }
        if (queryNoticesOptions.aggregation() != null) {
            builder.query(new Object[]{"aggregation", queryNoticesOptions.aggregation()});
        }
        if (queryNoticesOptions.count() != null) {
            builder.query(new Object[]{"count", String.valueOf(queryNoticesOptions.count())});
        }
        if (queryNoticesOptions.xReturn() != null) {
            builder.query(new Object[]{"return", RequestUtils.join(queryNoticesOptions.xReturn(), (String)",")});
        }
        if (queryNoticesOptions.offset() != null) {
            builder.query(new Object[]{"offset", String.valueOf(queryNoticesOptions.offset())});
        }
        if (queryNoticesOptions.sort() != null) {
            builder.query(new Object[]{"sort", RequestUtils.join(queryNoticesOptions.sort(), (String)",")});
        }
        if (queryNoticesOptions.highlight() != null) {
            builder.query(new Object[]{"highlight", String.valueOf(queryNoticesOptions.highlight())});
        }
        if (queryNoticesOptions.passagesFields() != null) {
            builder.query(new Object[]{"passages.fields", RequestUtils.join(queryNoticesOptions.passagesFields(), (String)",")});
        }
        if (queryNoticesOptions.passagesCount() != null) {
            builder.query(new Object[]{"passages.count", String.valueOf(queryNoticesOptions.passagesCount())});
        }
        if (queryNoticesOptions.passagesCharacters() != null) {
            builder.query(new Object[]{"passages.characters", String.valueOf(queryNoticesOptions.passagesCharacters())});
        }
        if (queryNoticesOptions.deduplicateField() != null) {
            builder.query(new Object[]{"deduplicate.field", queryNoticesOptions.deduplicateField()});
        }
        if (queryNoticesOptions.similar() != null) {
            builder.query(new Object[]{"similar", String.valueOf(queryNoticesOptions.similar())});
        }
        if (queryNoticesOptions.similarDocumentIds() != null) {
            builder.query(new Object[]{"similar.document_ids", RequestUtils.join(queryNoticesOptions.similarDocumentIds(), (String)",")});
        }
        if (queryNoticesOptions.similarFields() != null) {
            builder.query(new Object[]{"similar.fields", RequestUtils.join(queryNoticesOptions.similarFields(), (String)",")});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<QueryNoticesResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<QueryResponse> federatedQuery(FederatedQueryOptions federatedQueryOptions) {
        Validator.notNull((Object)((Object)federatedQueryOptions), (String)"federatedQueryOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "query"};
        String[] pathParameters = new String[]{federatedQueryOptions.environmentId()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v1", (String)"federatedQuery");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (federatedQueryOptions.xWatsonLoggingOptOut() != null) {
            builder.header(new Object[]{"X-Watson-Logging-Opt-Out", federatedQueryOptions.xWatsonLoggingOptOut()});
        }
        JsonObject contentJson = new JsonObject();
        if (federatedQueryOptions.filter() != null) {
            contentJson.addProperty("filter", federatedQueryOptions.filter());
        }
        if (federatedQueryOptions.query() != null) {
            contentJson.addProperty("query", federatedQueryOptions.query());
        }
        if (federatedQueryOptions.naturalLanguageQuery() != null) {
            contentJson.addProperty("natural_language_query", federatedQueryOptions.naturalLanguageQuery());
        }
        if (federatedQueryOptions.passages() != null) {
            contentJson.addProperty("passages", federatedQueryOptions.passages());
        }
        if (federatedQueryOptions.aggregation() != null) {
            contentJson.addProperty("aggregation", federatedQueryOptions.aggregation());
        }
        if (federatedQueryOptions.count() != null) {
            contentJson.addProperty("count", (Number)federatedQueryOptions.count());
        }
        if (federatedQueryOptions.xReturn() != null) {
            contentJson.addProperty("return", federatedQueryOptions.xReturn());
        }
        if (federatedQueryOptions.offset() != null) {
            contentJson.addProperty("offset", (Number)federatedQueryOptions.offset());
        }
        if (federatedQueryOptions.sort() != null) {
            contentJson.addProperty("sort", federatedQueryOptions.sort());
        }
        if (federatedQueryOptions.highlight() != null) {
            contentJson.addProperty("highlight", federatedQueryOptions.highlight());
        }
        if (federatedQueryOptions.passagesFields() != null) {
            contentJson.addProperty("passages.fields", federatedQueryOptions.passagesFields());
        }
        if (federatedQueryOptions.passagesCount() != null) {
            contentJson.addProperty("passages.count", (Number)federatedQueryOptions.passagesCount());
        }
        if (federatedQueryOptions.passagesCharacters() != null) {
            contentJson.addProperty("passages.characters", (Number)federatedQueryOptions.passagesCharacters());
        }
        if (federatedQueryOptions.deduplicate() != null) {
            contentJson.addProperty("deduplicate", federatedQueryOptions.deduplicate());
        }
        if (federatedQueryOptions.deduplicateField() != null) {
            contentJson.addProperty("deduplicate.field", federatedQueryOptions.deduplicateField());
        }
        if (federatedQueryOptions.similar() != null) {
            contentJson.addProperty("similar", federatedQueryOptions.similar());
        }
        if (federatedQueryOptions.similarDocumentIds() != null) {
            contentJson.addProperty("similar.document_ids", federatedQueryOptions.similarDocumentIds());
        }
        if (federatedQueryOptions.similarFields() != null) {
            contentJson.addProperty("similar.fields", federatedQueryOptions.similarFields());
        }
        if (federatedQueryOptions.bias() != null) {
            contentJson.addProperty("bias", federatedQueryOptions.bias());
        }
        if (federatedQueryOptions.collectionIds() != null) {
            contentJson.addProperty("collection_ids", federatedQueryOptions.collectionIds());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<QueryResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<QueryNoticesResponse> federatedQueryNotices(FederatedQueryNoticesOptions federatedQueryNoticesOptions) {
        Validator.notNull((Object)((Object)federatedQueryNoticesOptions), (String)"federatedQueryNoticesOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "notices"};
        String[] pathParameters = new String[]{federatedQueryNoticesOptions.environmentId()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v1", (String)"federatedQueryNotices");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"collection_ids", RequestUtils.join(federatedQueryNoticesOptions.collectionIds(), (String)",")});
        if (federatedQueryNoticesOptions.filter() != null) {
            builder.query(new Object[]{"filter", federatedQueryNoticesOptions.filter()});
        }
        if (federatedQueryNoticesOptions.query() != null) {
            builder.query(new Object[]{"query", federatedQueryNoticesOptions.query()});
        }
        if (federatedQueryNoticesOptions.naturalLanguageQuery() != null) {
            builder.query(new Object[]{"natural_language_query", federatedQueryNoticesOptions.naturalLanguageQuery()});
        }
        if (federatedQueryNoticesOptions.aggregation() != null) {
            builder.query(new Object[]{"aggregation", federatedQueryNoticesOptions.aggregation()});
        }
        if (federatedQueryNoticesOptions.count() != null) {
            builder.query(new Object[]{"count", String.valueOf(federatedQueryNoticesOptions.count())});
        }
        if (federatedQueryNoticesOptions.xReturn() != null) {
            builder.query(new Object[]{"return", RequestUtils.join(federatedQueryNoticesOptions.xReturn(), (String)",")});
        }
        if (federatedQueryNoticesOptions.offset() != null) {
            builder.query(new Object[]{"offset", String.valueOf(federatedQueryNoticesOptions.offset())});
        }
        if (federatedQueryNoticesOptions.sort() != null) {
            builder.query(new Object[]{"sort", RequestUtils.join(federatedQueryNoticesOptions.sort(), (String)",")});
        }
        if (federatedQueryNoticesOptions.highlight() != null) {
            builder.query(new Object[]{"highlight", String.valueOf(federatedQueryNoticesOptions.highlight())});
        }
        if (federatedQueryNoticesOptions.deduplicateField() != null) {
            builder.query(new Object[]{"deduplicate.field", federatedQueryNoticesOptions.deduplicateField()});
        }
        if (federatedQueryNoticesOptions.similar() != null) {
            builder.query(new Object[]{"similar", String.valueOf(federatedQueryNoticesOptions.similar())});
        }
        if (federatedQueryNoticesOptions.similarDocumentIds() != null) {
            builder.query(new Object[]{"similar.document_ids", RequestUtils.join(federatedQueryNoticesOptions.similarDocumentIds(), (String)",")});
        }
        if (federatedQueryNoticesOptions.similarFields() != null) {
            builder.query(new Object[]{"similar.fields", RequestUtils.join(federatedQueryNoticesOptions.similarFields(), (String)",")});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<QueryNoticesResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Completions> getAutocompletion(GetAutocompletionOptions getAutocompletionOptions) {
        Validator.notNull((Object)((Object)getAutocompletionOptions), (String)"getAutocompletionOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "collections", "autocompletion"};
        String[] pathParameters = new String[]{getAutocompletionOptions.environmentId(), getAutocompletionOptions.collectionId()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v1", (String)"getAutocompletion");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"prefix", getAutocompletionOptions.prefix()});
        if (getAutocompletionOptions.field() != null) {
            builder.query(new Object[]{"field", getAutocompletionOptions.field()});
        }
        if (getAutocompletionOptions.count() != null) {
            builder.query(new Object[]{"count", String.valueOf(getAutocompletionOptions.count())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Completions>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<TrainingDataSet> listTrainingData(ListTrainingDataOptions listTrainingDataOptions) {
        Validator.notNull((Object)((Object)listTrainingDataOptions), (String)"listTrainingDataOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "collections", "training_data"};
        String[] pathParameters = new String[]{listTrainingDataOptions.environmentId(), listTrainingDataOptions.collectionId()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v1", (String)"listTrainingData");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<TrainingDataSet>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<TrainingQuery> addTrainingData(AddTrainingDataOptions addTrainingDataOptions) {
        Validator.notNull((Object)((Object)addTrainingDataOptions), (String)"addTrainingDataOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "collections", "training_data"};
        String[] pathParameters = new String[]{addTrainingDataOptions.environmentId(), addTrainingDataOptions.collectionId()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v1", (String)"addTrainingData");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        if (addTrainingDataOptions.naturalLanguageQuery() != null) {
            contentJson.addProperty("natural_language_query", addTrainingDataOptions.naturalLanguageQuery());
        }
        if (addTrainingDataOptions.filter() != null) {
            contentJson.addProperty("filter", addTrainingDataOptions.filter());
        }
        if (addTrainingDataOptions.examples() != null) {
            contentJson.add("examples", GsonSingleton.getGson().toJsonTree(addTrainingDataOptions.examples()));
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<TrainingQuery>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteAllTrainingData(DeleteAllTrainingDataOptions deleteAllTrainingDataOptions) {
        Validator.notNull((Object)((Object)deleteAllTrainingDataOptions), (String)"deleteAllTrainingDataOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "collections", "training_data"};
        String[] pathParameters = new String[]{deleteAllTrainingDataOptions.environmentId(), deleteAllTrainingDataOptions.collectionId()};
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v1", (String)"deleteAllTrainingData");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<TrainingQuery> getTrainingData(GetTrainingDataOptions getTrainingDataOptions) {
        Validator.notNull((Object)((Object)getTrainingDataOptions), (String)"getTrainingDataOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "collections", "training_data"};
        String[] pathParameters = new String[]{getTrainingDataOptions.environmentId(), getTrainingDataOptions.collectionId(), getTrainingDataOptions.queryId()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v1", (String)"getTrainingData");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<TrainingQuery>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteTrainingData(DeleteTrainingDataOptions deleteTrainingDataOptions) {
        Validator.notNull((Object)((Object)deleteTrainingDataOptions), (String)"deleteTrainingDataOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "collections", "training_data"};
        String[] pathParameters = new String[]{deleteTrainingDataOptions.environmentId(), deleteTrainingDataOptions.collectionId(), deleteTrainingDataOptions.queryId()};
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v1", (String)"deleteTrainingData");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<TrainingExampleList> listTrainingExamples(ListTrainingExamplesOptions listTrainingExamplesOptions) {
        Validator.notNull((Object)((Object)listTrainingExamplesOptions), (String)"listTrainingExamplesOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "collections", "training_data", "examples"};
        String[] pathParameters = new String[]{listTrainingExamplesOptions.environmentId(), listTrainingExamplesOptions.collectionId(), listTrainingExamplesOptions.queryId()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v1", (String)"listTrainingExamples");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<TrainingExampleList>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<TrainingExample> createTrainingExample(CreateTrainingExampleOptions createTrainingExampleOptions) {
        Validator.notNull((Object)((Object)createTrainingExampleOptions), (String)"createTrainingExampleOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "collections", "training_data", "examples"};
        String[] pathParameters = new String[]{createTrainingExampleOptions.environmentId(), createTrainingExampleOptions.collectionId(), createTrainingExampleOptions.queryId()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v1", (String)"createTrainingExample");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        if (createTrainingExampleOptions.documentId() != null) {
            contentJson.addProperty("document_id", createTrainingExampleOptions.documentId());
        }
        if (createTrainingExampleOptions.crossReference() != null) {
            contentJson.addProperty("cross_reference", createTrainingExampleOptions.crossReference());
        }
        if (createTrainingExampleOptions.relevance() != null) {
            contentJson.addProperty("relevance", (Number)createTrainingExampleOptions.relevance());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<TrainingExample>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteTrainingExample(DeleteTrainingExampleOptions deleteTrainingExampleOptions) {
        Validator.notNull((Object)((Object)deleteTrainingExampleOptions), (String)"deleteTrainingExampleOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "collections", "training_data", "examples"};
        String[] pathParameters = new String[]{deleteTrainingExampleOptions.environmentId(), deleteTrainingExampleOptions.collectionId(), deleteTrainingExampleOptions.queryId(), deleteTrainingExampleOptions.exampleId()};
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v1", (String)"deleteTrainingExample");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<TrainingExample> updateTrainingExample(UpdateTrainingExampleOptions updateTrainingExampleOptions) {
        Validator.notNull((Object)((Object)updateTrainingExampleOptions), (String)"updateTrainingExampleOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "collections", "training_data", "examples"};
        String[] pathParameters = new String[]{updateTrainingExampleOptions.environmentId(), updateTrainingExampleOptions.collectionId(), updateTrainingExampleOptions.queryId(), updateTrainingExampleOptions.exampleId()};
        RequestBuilder builder = RequestBuilder.put((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v1", (String)"updateTrainingExample");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        if (updateTrainingExampleOptions.crossReference() != null) {
            contentJson.addProperty("cross_reference", updateTrainingExampleOptions.crossReference());
        }
        if (updateTrainingExampleOptions.relevance() != null) {
            contentJson.addProperty("relevance", (Number)updateTrainingExampleOptions.relevance());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<TrainingExample>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<TrainingExample> getTrainingExample(GetTrainingExampleOptions getTrainingExampleOptions) {
        Validator.notNull((Object)((Object)getTrainingExampleOptions), (String)"getTrainingExampleOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "collections", "training_data", "examples"};
        String[] pathParameters = new String[]{getTrainingExampleOptions.environmentId(), getTrainingExampleOptions.collectionId(), getTrainingExampleOptions.queryId(), getTrainingExampleOptions.exampleId()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v1", (String)"getTrainingExample");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<TrainingExample>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteUserData(DeleteUserDataOptions deleteUserDataOptions) {
        Validator.notNull((Object)((Object)deleteUserDataOptions), (String)"deleteUserDataOptions cannot be null");
        String[] pathSegments = new String[]{"v1/user_data"};
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v1", (String)"deleteUserData");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.query(new Object[]{"customer_id", deleteUserDataOptions.customerId()});
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<CreateEventResponse> createEvent(CreateEventOptions createEventOptions) {
        Validator.notNull((Object)((Object)createEventOptions), (String)"createEventOptions cannot be null");
        String[] pathSegments = new String[]{"v1/events"};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v1", (String)"createEvent");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("type", createEventOptions.type());
        contentJson.add("data", GsonSingleton.getGson().toJsonTree((Object)createEventOptions.data()));
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<CreateEventResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<LogQueryResponse> queryLog(QueryLogOptions queryLogOptions) {
        String[] pathSegments = new String[]{"v1/logs"};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v1", (String)"queryLog");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (queryLogOptions != null) {
            if (queryLogOptions.filter() != null) {
                builder.query(new Object[]{"filter", queryLogOptions.filter()});
            }
            if (queryLogOptions.query() != null) {
                builder.query(new Object[]{"query", queryLogOptions.query()});
            }
            if (queryLogOptions.count() != null) {
                builder.query(new Object[]{"count", String.valueOf(queryLogOptions.count())});
            }
            if (queryLogOptions.offset() != null) {
                builder.query(new Object[]{"offset", String.valueOf(queryLogOptions.offset())});
            }
            if (queryLogOptions.sort() != null) {
                builder.query(new Object[]{"sort", RequestUtils.join(queryLogOptions.sort(), (String)",")});
            }
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<LogQueryResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<LogQueryResponse> queryLog() {
        return this.queryLog(null);
    }

    public ServiceCall<MetricResponse> getMetricsQuery(GetMetricsQueryOptions getMetricsQueryOptions) {
        String[] pathSegments = new String[]{"v1/metrics/number_of_queries"};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v1", (String)"getMetricsQuery");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (getMetricsQueryOptions != null) {
            if (getMetricsQueryOptions.startTime() != null) {
                builder.query(new Object[]{"start_time", String.valueOf(getMetricsQueryOptions.startTime())});
            }
            if (getMetricsQueryOptions.endTime() != null) {
                builder.query(new Object[]{"end_time", String.valueOf(getMetricsQueryOptions.endTime())});
            }
            if (getMetricsQueryOptions.resultType() != null) {
                builder.query(new Object[]{"result_type", getMetricsQueryOptions.resultType()});
            }
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<MetricResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<MetricResponse> getMetricsQuery() {
        return this.getMetricsQuery(null);
    }

    public ServiceCall<MetricResponse> getMetricsQueryEvent(GetMetricsQueryEventOptions getMetricsQueryEventOptions) {
        String[] pathSegments = new String[]{"v1/metrics/number_of_queries_with_event"};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v1", (String)"getMetricsQueryEvent");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (getMetricsQueryEventOptions != null) {
            if (getMetricsQueryEventOptions.startTime() != null) {
                builder.query(new Object[]{"start_time", String.valueOf(getMetricsQueryEventOptions.startTime())});
            }
            if (getMetricsQueryEventOptions.endTime() != null) {
                builder.query(new Object[]{"end_time", String.valueOf(getMetricsQueryEventOptions.endTime())});
            }
            if (getMetricsQueryEventOptions.resultType() != null) {
                builder.query(new Object[]{"result_type", getMetricsQueryEventOptions.resultType()});
            }
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<MetricResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<MetricResponse> getMetricsQueryEvent() {
        return this.getMetricsQueryEvent(null);
    }

    public ServiceCall<MetricResponse> getMetricsQueryNoResults(GetMetricsQueryNoResultsOptions getMetricsQueryNoResultsOptions) {
        String[] pathSegments = new String[]{"v1/metrics/number_of_queries_with_no_search_results"};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v1", (String)"getMetricsQueryNoResults");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (getMetricsQueryNoResultsOptions != null) {
            if (getMetricsQueryNoResultsOptions.startTime() != null) {
                builder.query(new Object[]{"start_time", String.valueOf(getMetricsQueryNoResultsOptions.startTime())});
            }
            if (getMetricsQueryNoResultsOptions.endTime() != null) {
                builder.query(new Object[]{"end_time", String.valueOf(getMetricsQueryNoResultsOptions.endTime())});
            }
            if (getMetricsQueryNoResultsOptions.resultType() != null) {
                builder.query(new Object[]{"result_type", getMetricsQueryNoResultsOptions.resultType()});
            }
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<MetricResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<MetricResponse> getMetricsQueryNoResults() {
        return this.getMetricsQueryNoResults(null);
    }

    public ServiceCall<MetricResponse> getMetricsEventRate(GetMetricsEventRateOptions getMetricsEventRateOptions) {
        String[] pathSegments = new String[]{"v1/metrics/event_rate"};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v1", (String)"getMetricsEventRate");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (getMetricsEventRateOptions != null) {
            if (getMetricsEventRateOptions.startTime() != null) {
                builder.query(new Object[]{"start_time", String.valueOf(getMetricsEventRateOptions.startTime())});
            }
            if (getMetricsEventRateOptions.endTime() != null) {
                builder.query(new Object[]{"end_time", String.valueOf(getMetricsEventRateOptions.endTime())});
            }
            if (getMetricsEventRateOptions.resultType() != null) {
                builder.query(new Object[]{"result_type", getMetricsEventRateOptions.resultType()});
            }
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<MetricResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<MetricResponse> getMetricsEventRate() {
        return this.getMetricsEventRate(null);
    }

    public ServiceCall<MetricTokenResponse> getMetricsQueryTokenEvent(GetMetricsQueryTokenEventOptions getMetricsQueryTokenEventOptions) {
        String[] pathSegments = new String[]{"v1/metrics/top_query_tokens_with_event_rate"};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v1", (String)"getMetricsQueryTokenEvent");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (getMetricsQueryTokenEventOptions != null && getMetricsQueryTokenEventOptions.count() != null) {
            builder.query(new Object[]{"count", String.valueOf(getMetricsQueryTokenEventOptions.count())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<MetricTokenResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<MetricTokenResponse> getMetricsQueryTokenEvent() {
        return this.getMetricsQueryTokenEvent(null);
    }

    public ServiceCall<CredentialsList> listCredentials(ListCredentialsOptions listCredentialsOptions) {
        Validator.notNull((Object)((Object)listCredentialsOptions), (String)"listCredentialsOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "credentials"};
        String[] pathParameters = new String[]{listCredentialsOptions.environmentId()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v1", (String)"listCredentials");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<CredentialsList>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Credentials> createCredentials(CreateCredentialsOptions createCredentialsOptions) {
        Validator.notNull((Object)((Object)createCredentialsOptions), (String)"createCredentialsOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "credentials"};
        String[] pathParameters = new String[]{createCredentialsOptions.environmentId()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v1", (String)"createCredentials");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        if (createCredentialsOptions.sourceType() != null) {
            contentJson.addProperty("source_type", createCredentialsOptions.sourceType());
        }
        if (createCredentialsOptions.credentialDetails() != null) {
            contentJson.add("credential_details", GsonSingleton.getGson().toJsonTree((Object)createCredentialsOptions.credentialDetails()));
        }
        if (createCredentialsOptions.status() != null) {
            contentJson.addProperty("status", createCredentialsOptions.status());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Credentials>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Credentials> getCredentials(GetCredentialsOptions getCredentialsOptions) {
        Validator.notNull((Object)((Object)getCredentialsOptions), (String)"getCredentialsOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "credentials"};
        String[] pathParameters = new String[]{getCredentialsOptions.environmentId(), getCredentialsOptions.credentialId()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v1", (String)"getCredentials");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Credentials>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Credentials> updateCredentials(UpdateCredentialsOptions updateCredentialsOptions) {
        Validator.notNull((Object)((Object)updateCredentialsOptions), (String)"updateCredentialsOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "credentials"};
        String[] pathParameters = new String[]{updateCredentialsOptions.environmentId(), updateCredentialsOptions.credentialId()};
        RequestBuilder builder = RequestBuilder.put((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v1", (String)"updateCredentials");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        if (updateCredentialsOptions.sourceType() != null) {
            contentJson.addProperty("source_type", updateCredentialsOptions.sourceType());
        }
        if (updateCredentialsOptions.credentialDetails() != null) {
            contentJson.add("credential_details", GsonSingleton.getGson().toJsonTree((Object)updateCredentialsOptions.credentialDetails()));
        }
        if (updateCredentialsOptions.status() != null) {
            contentJson.addProperty("status", updateCredentialsOptions.status());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Credentials>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<DeleteCredentials> deleteCredentials(DeleteCredentialsOptions deleteCredentialsOptions) {
        Validator.notNull((Object)((Object)deleteCredentialsOptions), (String)"deleteCredentialsOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "credentials"};
        String[] pathParameters = new String[]{deleteCredentialsOptions.environmentId(), deleteCredentialsOptions.credentialId()};
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v1", (String)"deleteCredentials");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<DeleteCredentials>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<GatewayList> listGateways(ListGatewaysOptions listGatewaysOptions) {
        Validator.notNull((Object)((Object)listGatewaysOptions), (String)"listGatewaysOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "gateways"};
        String[] pathParameters = new String[]{listGatewaysOptions.environmentId()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v1", (String)"listGateways");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<GatewayList>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Gateway> createGateway(CreateGatewayOptions createGatewayOptions) {
        Validator.notNull((Object)((Object)createGatewayOptions), (String)"createGatewayOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "gateways"};
        String[] pathParameters = new String[]{createGatewayOptions.environmentId()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v1", (String)"createGateway");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        if (createGatewayOptions.name() != null) {
            contentJson.addProperty("name", createGatewayOptions.name());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Gateway>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Gateway> getGateway(GetGatewayOptions getGatewayOptions) {
        Validator.notNull((Object)((Object)getGatewayOptions), (String)"getGatewayOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "gateways"};
        String[] pathParameters = new String[]{getGatewayOptions.environmentId(), getGatewayOptions.gatewayId()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v1", (String)"getGateway");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Gateway>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<GatewayDelete> deleteGateway(DeleteGatewayOptions deleteGatewayOptions) {
        Validator.notNull((Object)((Object)deleteGatewayOptions), (String)"deleteGatewayOptions cannot be null");
        String[] pathSegments = new String[]{"v1/environments", "gateways"};
        String[] pathParameters = new String[]{deleteGatewayOptions.environmentId(), deleteGatewayOptions.gatewayId()};
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v1", (String)"deleteGateway");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<GatewayDelete>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }
}

