/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.discovery.v1.model.TrainingExample;
import java.util.ArrayList;
import java.util.List;

public class AddTrainingDataOptions
extends GenericModel {
    private String environmentId;
    private String collectionId;
    private String naturalLanguageQuery;
    private String filter;
    private List<TrainingExample> examples;

    private AddTrainingDataOptions(Builder builder) {
        Validator.notEmpty((String)builder.environmentId, (String)"environmentId cannot be empty");
        Validator.notEmpty((String)builder.collectionId, (String)"collectionId cannot be empty");
        this.environmentId = builder.environmentId;
        this.collectionId = builder.collectionId;
        this.naturalLanguageQuery = builder.naturalLanguageQuery;
        this.filter = builder.filter;
        this.examples = builder.examples;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String environmentId() {
        return this.environmentId;
    }

    public String collectionId() {
        return this.collectionId;
    }

    public String naturalLanguageQuery() {
        return this.naturalLanguageQuery;
    }

    public String filter() {
        return this.filter;
    }

    public List<TrainingExample> examples() {
        return this.examples;
    }

    public static class Builder {
        private String environmentId;
        private String collectionId;
        private String naturalLanguageQuery;
        private String filter;
        private List<TrainingExample> examples;

        private Builder(AddTrainingDataOptions addTrainingDataOptions) {
            this.environmentId = addTrainingDataOptions.environmentId;
            this.collectionId = addTrainingDataOptions.collectionId;
            this.naturalLanguageQuery = addTrainingDataOptions.naturalLanguageQuery;
            this.filter = addTrainingDataOptions.filter;
            this.examples = addTrainingDataOptions.examples;
        }

        public Builder() {
        }

        public Builder(String environmentId, String collectionId) {
            this.environmentId = environmentId;
            this.collectionId = collectionId;
        }

        public AddTrainingDataOptions build() {
            return new AddTrainingDataOptions(this);
        }

        public Builder addExamples(TrainingExample examples) {
            Validator.notNull((Object)((Object)examples), (String)"examples cannot be null");
            if (this.examples == null) {
                this.examples = new ArrayList<TrainingExample>();
            }
            this.examples.add(examples);
            return this;
        }

        public Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public Builder naturalLanguageQuery(String naturalLanguageQuery) {
            this.naturalLanguageQuery = naturalLanguageQuery;
            return this;
        }

        public Builder filter(String filter) {
            this.filter = filter;
            return this;
        }

        public Builder examples(List<TrainingExample> examples) {
            this.examples = examples;
            return this;
        }
    }
}

