/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v1.model;

import com.google.gson.annotations.SerializedName;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.watson.discovery.v1.model.CredentialDetails;

public class Credentials
extends GenericModel {
    @SerializedName(value="credential_id")
    private String credentialId;
    @SerializedName(value="source_type")
    private String sourceType;
    @SerializedName(value="credential_details")
    private CredentialDetails credentialDetails;
    private String status;

    private Credentials(Builder builder) {
        this.credentialId = builder.credentialId;
        this.sourceType = builder.sourceType;
        this.credentialDetails = builder.credentialDetails;
        this.status = builder.status;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String credentialId() {
        return this.credentialId;
    }

    public String sourceType() {
        return this.sourceType;
    }

    public CredentialDetails credentialDetails() {
        return this.credentialDetails;
    }

    public String status() {
        return this.status;
    }

    public static class Builder {
        private String credentialId;
        private String sourceType;
        private CredentialDetails credentialDetails;
        private String status;

        private Builder(Credentials credentials) {
            this.credentialId = credentials.credentialId;
            this.sourceType = credentials.sourceType;
            this.credentialDetails = credentials.credentialDetails;
            this.status = credentials.status;
        }

        public Builder() {
        }

        public Credentials build() {
            return new Credentials(this);
        }

        public Builder credentialId(String credentialId) {
            this.credentialId = credentialId;
            return this;
        }

        public Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public Builder credentialDetails(CredentialDetails credentialDetails) {
            this.credentialDetails = credentialDetails;
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            return this;
        }
    }

    public static interface Status {
        public static final String CONNECTED = "connected";
        public static final String INVALID = "invalid";
    }

    public static interface SourceType {
        public static final String BOX = "box";
        public static final String SALESFORCE = "salesforce";
        public static final String SHAREPOINT = "sharepoint";
        public static final String WEB_CRAWL = "web_crawl";
        public static final String CLOUD_OBJECT_STORAGE = "cloud_object_storage";
    }
}

