/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;

public class DeleteDocumentOptions
extends GenericModel {
    private String environmentId;
    private String collectionId;
    private String documentId;

    private DeleteDocumentOptions(Builder builder) {
        Validator.notEmpty((String)builder.environmentId, (String)"environmentId cannot be empty");
        Validator.notEmpty((String)builder.collectionId, (String)"collectionId cannot be empty");
        Validator.notEmpty((String)builder.documentId, (String)"documentId cannot be empty");
        this.environmentId = builder.environmentId;
        this.collectionId = builder.collectionId;
        this.documentId = builder.documentId;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String environmentId() {
        return this.environmentId;
    }

    public String collectionId() {
        return this.collectionId;
    }

    public String documentId() {
        return this.documentId;
    }

    public static class Builder {
        private String environmentId;
        private String collectionId;
        private String documentId;

        private Builder(DeleteDocumentOptions deleteDocumentOptions) {
            this.environmentId = deleteDocumentOptions.environmentId;
            this.collectionId = deleteDocumentOptions.collectionId;
            this.documentId = deleteDocumentOptions.documentId;
        }

        public Builder() {
        }

        public Builder(String environmentId, String collectionId, String documentId) {
            this.environmentId = environmentId;
            this.collectionId = collectionId;
            this.documentId = documentId;
        }

        public DeleteDocumentOptions build() {
            return new DeleteDocumentOptions(this);
        }

        public Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public Builder documentId(String documentId) {
            this.documentId = documentId;
            return this;
        }
    }
}

