/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;

public class QueryOptions
extends GenericModel {
    private String environmentId;
    private String collectionId;
    private String filter;
    private String query;
    private String naturalLanguageQuery;
    private Boolean passages;
    private String aggregation;
    private Long count;
    private String xReturn;
    private Long offset;
    private String sort;
    private Boolean highlight;
    private String passagesFields;
    private Long passagesCount;
    private Long passagesCharacters;
    private Boolean deduplicate;
    private String deduplicateField;
    private Boolean similar;
    private String similarDocumentIds;
    private String similarFields;
    private String bias;
    private Boolean spellingSuggestions;
    private Boolean xWatsonLoggingOptOut;

    private QueryOptions(Builder builder) {
        Validator.notEmpty((String)builder.environmentId, (String)"environmentId cannot be empty");
        Validator.notEmpty((String)builder.collectionId, (String)"collectionId cannot be empty");
        this.environmentId = builder.environmentId;
        this.collectionId = builder.collectionId;
        this.filter = builder.filter;
        this.query = builder.query;
        this.naturalLanguageQuery = builder.naturalLanguageQuery;
        this.passages = builder.passages;
        this.aggregation = builder.aggregation;
        this.count = builder.count;
        this.xReturn = builder.xReturn;
        this.offset = builder.offset;
        this.sort = builder.sort;
        this.highlight = builder.highlight;
        this.passagesFields = builder.passagesFields;
        this.passagesCount = builder.passagesCount;
        this.passagesCharacters = builder.passagesCharacters;
        this.deduplicate = builder.deduplicate;
        this.deduplicateField = builder.deduplicateField;
        this.similar = builder.similar;
        this.similarDocumentIds = builder.similarDocumentIds;
        this.similarFields = builder.similarFields;
        this.bias = builder.bias;
        this.spellingSuggestions = builder.spellingSuggestions;
        this.xWatsonLoggingOptOut = builder.xWatsonLoggingOptOut;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String environmentId() {
        return this.environmentId;
    }

    public String collectionId() {
        return this.collectionId;
    }

    public String filter() {
        return this.filter;
    }

    public String query() {
        return this.query;
    }

    public String naturalLanguageQuery() {
        return this.naturalLanguageQuery;
    }

    public Boolean passages() {
        return this.passages;
    }

    public String aggregation() {
        return this.aggregation;
    }

    public Long count() {
        return this.count;
    }

    public String xReturn() {
        return this.xReturn;
    }

    public Long offset() {
        return this.offset;
    }

    public String sort() {
        return this.sort;
    }

    public Boolean highlight() {
        return this.highlight;
    }

    public String passagesFields() {
        return this.passagesFields;
    }

    public Long passagesCount() {
        return this.passagesCount;
    }

    public Long passagesCharacters() {
        return this.passagesCharacters;
    }

    public Boolean deduplicate() {
        return this.deduplicate;
    }

    public String deduplicateField() {
        return this.deduplicateField;
    }

    public Boolean similar() {
        return this.similar;
    }

    public String similarDocumentIds() {
        return this.similarDocumentIds;
    }

    public String similarFields() {
        return this.similarFields;
    }

    public String bias() {
        return this.bias;
    }

    public Boolean spellingSuggestions() {
        return this.spellingSuggestions;
    }

    public Boolean xWatsonLoggingOptOut() {
        return this.xWatsonLoggingOptOut;
    }

    public static class Builder {
        private String environmentId;
        private String collectionId;
        private String filter;
        private String query;
        private String naturalLanguageQuery;
        private Boolean passages;
        private String aggregation;
        private Long count;
        private String xReturn;
        private Long offset;
        private String sort;
        private Boolean highlight;
        private String passagesFields;
        private Long passagesCount;
        private Long passagesCharacters;
        private Boolean deduplicate;
        private String deduplicateField;
        private Boolean similar;
        private String similarDocumentIds;
        private String similarFields;
        private String bias;
        private Boolean spellingSuggestions;
        private Boolean xWatsonLoggingOptOut;

        private Builder(QueryOptions queryOptions) {
            this.environmentId = queryOptions.environmentId;
            this.collectionId = queryOptions.collectionId;
            this.filter = queryOptions.filter;
            this.query = queryOptions.query;
            this.naturalLanguageQuery = queryOptions.naturalLanguageQuery;
            this.passages = queryOptions.passages;
            this.aggregation = queryOptions.aggregation;
            this.count = queryOptions.count;
            this.xReturn = queryOptions.xReturn;
            this.offset = queryOptions.offset;
            this.sort = queryOptions.sort;
            this.highlight = queryOptions.highlight;
            this.passagesFields = queryOptions.passagesFields;
            this.passagesCount = queryOptions.passagesCount;
            this.passagesCharacters = queryOptions.passagesCharacters;
            this.deduplicate = queryOptions.deduplicate;
            this.deduplicateField = queryOptions.deduplicateField;
            this.similar = queryOptions.similar;
            this.similarDocumentIds = queryOptions.similarDocumentIds;
            this.similarFields = queryOptions.similarFields;
            this.bias = queryOptions.bias;
            this.spellingSuggestions = queryOptions.spellingSuggestions;
            this.xWatsonLoggingOptOut = queryOptions.xWatsonLoggingOptOut;
        }

        public Builder() {
        }

        public Builder(String environmentId, String collectionId) {
            this.environmentId = environmentId;
            this.collectionId = collectionId;
        }

        public QueryOptions build() {
            return new QueryOptions(this);
        }

        public Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public Builder filter(String filter) {
            this.filter = filter;
            return this;
        }

        public Builder query(String query) {
            this.query = query;
            return this;
        }

        public Builder naturalLanguageQuery(String naturalLanguageQuery) {
            this.naturalLanguageQuery = naturalLanguageQuery;
            return this;
        }

        public Builder passages(Boolean passages) {
            this.passages = passages;
            return this;
        }

        public Builder aggregation(String aggregation) {
            this.aggregation = aggregation;
            return this;
        }

        public Builder count(long count) {
            this.count = count;
            return this;
        }

        public Builder xReturn(String xReturn) {
            this.xReturn = xReturn;
            return this;
        }

        public Builder offset(long offset) {
            this.offset = offset;
            return this;
        }

        public Builder sort(String sort) {
            this.sort = sort;
            return this;
        }

        public Builder highlight(Boolean highlight) {
            this.highlight = highlight;
            return this;
        }

        public Builder passagesFields(String passagesFields) {
            this.passagesFields = passagesFields;
            return this;
        }

        public Builder passagesCount(long passagesCount) {
            this.passagesCount = passagesCount;
            return this;
        }

        public Builder passagesCharacters(long passagesCharacters) {
            this.passagesCharacters = passagesCharacters;
            return this;
        }

        public Builder deduplicate(Boolean deduplicate) {
            this.deduplicate = deduplicate;
            return this;
        }

        public Builder deduplicateField(String deduplicateField) {
            this.deduplicateField = deduplicateField;
            return this;
        }

        public Builder similar(Boolean similar) {
            this.similar = similar;
            return this;
        }

        public Builder similarDocumentIds(String similarDocumentIds) {
            this.similarDocumentIds = similarDocumentIds;
            return this;
        }

        public Builder similarFields(String similarFields) {
            this.similarFields = similarFields;
            return this;
        }

        public Builder bias(String bias) {
            this.bias = bias;
            return this;
        }

        public Builder spellingSuggestions(Boolean spellingSuggestions) {
            this.spellingSuggestions = spellingSuggestions;
            return this;
        }

        public Builder xWatsonLoggingOptOut(Boolean xWatsonLoggingOptOut) {
            this.xWatsonLoggingOptOut = xWatsonLoggingOptOut;
            return this;
        }
    }
}

