/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v1.model;

import com.google.gson.annotations.SerializedName;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class SegmentSettings
extends GenericModel {
    private Boolean enabled;
    @SerializedName(value="selector_tags")
    private List<String> selectorTags;
    @SerializedName(value="annotated_fields")
    private List<String> annotatedFields;

    private SegmentSettings(Builder builder) {
        this.enabled = builder.enabled;
        this.selectorTags = builder.selectorTags;
        this.annotatedFields = builder.annotatedFields;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public List<String> selectorTags() {
        return this.selectorTags;
    }

    public List<String> annotatedFields() {
        return this.annotatedFields;
    }

    public static class Builder {
        private Boolean enabled;
        private List<String> selectorTags;
        private List<String> annotatedFields;

        private Builder(SegmentSettings segmentSettings) {
            this.enabled = segmentSettings.enabled;
            this.selectorTags = segmentSettings.selectorTags;
            this.annotatedFields = segmentSettings.annotatedFields;
        }

        public Builder() {
        }

        public SegmentSettings build() {
            return new SegmentSettings(this);
        }

        public Builder addSelectorTags(String selectorTags) {
            Validator.notNull((Object)selectorTags, (String)"selectorTags cannot be null");
            if (this.selectorTags == null) {
                this.selectorTags = new ArrayList<String>();
            }
            this.selectorTags.add(selectorTags);
            return this;
        }

        public Builder addAnnotatedFields(String annotatedFields) {
            Validator.notNull((Object)annotatedFields, (String)"annotatedFields cannot be null");
            if (this.annotatedFields == null) {
                this.annotatedFields = new ArrayList<String>();
            }
            this.annotatedFields.add(annotatedFields);
            return this;
        }

        public Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder selectorTags(List<String> selectorTags) {
            this.selectorTags = selectorTags;
            return this;
        }

        public Builder annotatedFields(List<String> annotatedFields) {
            this.annotatedFields = annotatedFields;
            return this;
        }
    }
}

