/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v1.model;

import com.google.gson.annotations.SerializedName;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.watson.discovery.v1.model.SourceOptions;
import com.ibm.watson.discovery.v1.model.SourceSchedule;

public class Source
extends GenericModel {
    private String type;
    @SerializedName(value="credential_id")
    private String credentialId;
    private SourceSchedule schedule;
    private SourceOptions options;

    private Source(Builder builder) {
        this.type = builder.type;
        this.credentialId = builder.credentialId;
        this.schedule = builder.schedule;
        this.options = builder.options;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String type() {
        return this.type;
    }

    public String credentialId() {
        return this.credentialId;
    }

    public SourceSchedule schedule() {
        return this.schedule;
    }

    public SourceOptions options() {
        return this.options;
    }

    public static class Builder {
        private String type;
        private String credentialId;
        private SourceSchedule schedule;
        private SourceOptions options;

        private Builder(Source source) {
            this.type = source.type;
            this.credentialId = source.credentialId;
            this.schedule = source.schedule;
            this.options = source.options;
        }

        public Builder() {
        }

        public Source build() {
            return new Source(this);
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder credentialId(String credentialId) {
            this.credentialId = credentialId;
            return this;
        }

        public Builder schedule(SourceSchedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public Builder options(SourceOptions options) {
            this.options = options;
            return this;
        }
    }

    public static interface Type {
        public static final String BOX = "box";
        public static final String SALESFORCE = "salesforce";
        public static final String SHAREPOINT = "sharepoint";
        public static final String WEB_CRAWL = "web_crawl";
        public static final String CLOUD_OBJECT_STORAGE = "cloud_object_storage";
    }
}

