/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v1.model;

import com.google.gson.annotations.SerializedName;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.discovery.v1.model.SourceOptionsBuckets;
import com.ibm.watson.discovery.v1.model.SourceOptionsFolder;
import com.ibm.watson.discovery.v1.model.SourceOptionsObject;
import com.ibm.watson.discovery.v1.model.SourceOptionsSiteColl;
import com.ibm.watson.discovery.v1.model.SourceOptionsWebCrawl;
import java.util.ArrayList;
import java.util.List;

public class SourceOptions
extends GenericModel {
    private List<SourceOptionsFolder> folders;
    private List<SourceOptionsObject> objects;
    @SerializedName(value="site_collections")
    private List<SourceOptionsSiteColl> siteCollections;
    private List<SourceOptionsWebCrawl> urls;
    private List<SourceOptionsBuckets> buckets;
    @SerializedName(value="crawl_all_buckets")
    private Boolean crawlAllBuckets;

    private SourceOptions(Builder builder) {
        this.folders = builder.folders;
        this.objects = builder.objects;
        this.siteCollections = builder.siteCollections;
        this.urls = builder.urls;
        this.buckets = builder.buckets;
        this.crawlAllBuckets = builder.crawlAllBuckets;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public List<SourceOptionsFolder> folders() {
        return this.folders;
    }

    public List<SourceOptionsObject> objects() {
        return this.objects;
    }

    public List<SourceOptionsSiteColl> siteCollections() {
        return this.siteCollections;
    }

    public List<SourceOptionsWebCrawl> urls() {
        return this.urls;
    }

    public List<SourceOptionsBuckets> buckets() {
        return this.buckets;
    }

    public Boolean crawlAllBuckets() {
        return this.crawlAllBuckets;
    }

    public static class Builder {
        private List<SourceOptionsFolder> folders;
        private List<SourceOptionsObject> objects;
        private List<SourceOptionsSiteColl> siteCollections;
        private List<SourceOptionsWebCrawl> urls;
        private List<SourceOptionsBuckets> buckets;
        private Boolean crawlAllBuckets;

        private Builder(SourceOptions sourceOptions) {
            this.folders = sourceOptions.folders;
            this.objects = sourceOptions.objects;
            this.siteCollections = sourceOptions.siteCollections;
            this.urls = sourceOptions.urls;
            this.buckets = sourceOptions.buckets;
            this.crawlAllBuckets = sourceOptions.crawlAllBuckets;
        }

        public Builder() {
        }

        public SourceOptions build() {
            return new SourceOptions(this);
        }

        public Builder addFolders(SourceOptionsFolder folders) {
            Validator.notNull((Object)((Object)folders), (String)"folders cannot be null");
            if (this.folders == null) {
                this.folders = new ArrayList<SourceOptionsFolder>();
            }
            this.folders.add(folders);
            return this;
        }

        public Builder addObjects(SourceOptionsObject objects) {
            Validator.notNull((Object)((Object)objects), (String)"objects cannot be null");
            if (this.objects == null) {
                this.objects = new ArrayList<SourceOptionsObject>();
            }
            this.objects.add(objects);
            return this;
        }

        public Builder addSiteCollections(SourceOptionsSiteColl siteCollections) {
            Validator.notNull((Object)((Object)siteCollections), (String)"siteCollections cannot be null");
            if (this.siteCollections == null) {
                this.siteCollections = new ArrayList<SourceOptionsSiteColl>();
            }
            this.siteCollections.add(siteCollections);
            return this;
        }

        public Builder addUrls(SourceOptionsWebCrawl urls) {
            Validator.notNull((Object)((Object)urls), (String)"urls cannot be null");
            if (this.urls == null) {
                this.urls = new ArrayList<SourceOptionsWebCrawl>();
            }
            this.urls.add(urls);
            return this;
        }

        public Builder addBuckets(SourceOptionsBuckets buckets) {
            Validator.notNull((Object)((Object)buckets), (String)"buckets cannot be null");
            if (this.buckets == null) {
                this.buckets = new ArrayList<SourceOptionsBuckets>();
            }
            this.buckets.add(buckets);
            return this;
        }

        public Builder folders(List<SourceOptionsFolder> folders) {
            this.folders = folders;
            return this;
        }

        public Builder objects(List<SourceOptionsObject> objects) {
            this.objects = objects;
            return this;
        }

        public Builder siteCollections(List<SourceOptionsSiteColl> siteCollections) {
            this.siteCollections = siteCollections;
            return this;
        }

        public Builder urls(List<SourceOptionsWebCrawl> urls) {
            this.urls = urls;
            return this;
        }

        public Builder buckets(List<SourceOptionsBuckets> buckets) {
            this.buckets = buckets;
            return this;
        }

        public Builder crawlAllBuckets(Boolean crawlAllBuckets) {
            this.crawlAllBuckets = crawlAllBuckets;
            return this;
        }
    }
}

