/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v1.model;

import com.google.gson.annotations.SerializedName;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;

public class SourceOptionsFolder
extends GenericModel {
    @SerializedName(value="owner_user_id")
    private String ownerUserId;
    @SerializedName(value="folder_id")
    private String folderId;
    private Long limit;

    private SourceOptionsFolder(Builder builder) {
        Validator.notNull((Object)builder.ownerUserId, (String)"ownerUserId cannot be null");
        Validator.notNull((Object)builder.folderId, (String)"folderId cannot be null");
        this.ownerUserId = builder.ownerUserId;
        this.folderId = builder.folderId;
        this.limit = builder.limit;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String ownerUserId() {
        return this.ownerUserId;
    }

    public String folderId() {
        return this.folderId;
    }

    public Long limit() {
        return this.limit;
    }

    public static class Builder {
        private String ownerUserId;
        private String folderId;
        private Long limit;

        private Builder(SourceOptionsFolder sourceOptionsFolder) {
            this.ownerUserId = sourceOptionsFolder.ownerUserId;
            this.folderId = sourceOptionsFolder.folderId;
            this.limit = sourceOptionsFolder.limit;
        }

        public Builder() {
        }

        public Builder(String ownerUserId, String folderId) {
            this.ownerUserId = ownerUserId;
            this.folderId = folderId;
        }

        public SourceOptionsFolder build() {
            return new SourceOptionsFolder(this);
        }

        public Builder ownerUserId(String ownerUserId) {
            this.ownerUserId = ownerUserId;
            return this;
        }

        public Builder folderId(String folderId) {
            this.folderId = folderId;
            return this;
        }

        public Builder limit(long limit) {
            this.limit = limit;
            return this;
        }
    }
}

