/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.discovery.v1.model.FontSetting;
import com.ibm.watson.discovery.v1.model.WordStyle;
import java.util.ArrayList;
import java.util.List;

public class WordHeadingDetection
extends GenericModel {
    private List<FontSetting> fonts;
    private List<WordStyle> styles;

    private WordHeadingDetection(Builder builder) {
        this.fonts = builder.fonts;
        this.styles = builder.styles;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public List<FontSetting> fonts() {
        return this.fonts;
    }

    public List<WordStyle> styles() {
        return this.styles;
    }

    public static class Builder {
        private List<FontSetting> fonts;
        private List<WordStyle> styles;

        private Builder(WordHeadingDetection wordHeadingDetection) {
            this.fonts = wordHeadingDetection.fonts;
            this.styles = wordHeadingDetection.styles;
        }

        public Builder() {
        }

        public WordHeadingDetection build() {
            return new WordHeadingDetection(this);
        }

        public Builder addFontSetting(FontSetting fontSetting) {
            Validator.notNull((Object)((Object)fontSetting), (String)"fontSetting cannot be null");
            if (this.fonts == null) {
                this.fonts = new ArrayList<FontSetting>();
            }
            this.fonts.add(fontSetting);
            return this;
        }

        public Builder addWordStyle(WordStyle wordStyle) {
            Validator.notNull((Object)((Object)wordStyle), (String)"wordStyle cannot be null");
            if (this.styles == null) {
                this.styles = new ArrayList<WordStyle>();
            }
            this.styles.add(wordStyle);
            return this;
        }

        public Builder fonts(List<FontSetting> fonts) {
            this.fonts = fonts;
            return this;
        }

        public Builder styles(List<WordStyle> styles) {
            this.styles = styles;
            return this;
        }
    }
}

