/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class WordStyle
extends GenericModel {
    private Long level;
    private List<String> names;

    private WordStyle(Builder builder) {
        this.level = builder.level;
        this.names = builder.names;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public Long level() {
        return this.level;
    }

    public List<String> names() {
        return this.names;
    }

    public static class Builder {
        private Long level;
        private List<String> names;

        private Builder(WordStyle wordStyle) {
            this.level = wordStyle.level;
            this.names = wordStyle.names;
        }

        public Builder() {
        }

        public WordStyle build() {
            return new WordStyle(this);
        }

        public Builder addNames(String names) {
            Validator.notNull((Object)names, (String)"names cannot be null");
            if (this.names == null) {
                this.names = new ArrayList<String>();
            }
            this.names.add(names);
            return this;
        }

        public Builder level(long level) {
            this.level = level;
            return this;
        }

        public Builder names(List<String> names) {
            this.names = names;
            return this;
        }
    }
}

