/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.discovery.v1.model.Expansion;
import com.ibm.watson.discovery.v1.model.Expansions;
import java.util.ArrayList;
import java.util.List;

public class CreateExpansionsOptions
extends GenericModel {
    protected String environmentId;
    protected String collectionId;
    protected List<Expansion> expansions;

    protected CreateExpansionsOptions(Builder builder) {
        Validator.notEmpty((String)builder.environmentId, (String)"environmentId cannot be empty");
        Validator.notEmpty((String)builder.collectionId, (String)"collectionId cannot be empty");
        Validator.notNull((Object)builder.expansions, (String)"expansions cannot be null");
        this.environmentId = builder.environmentId;
        this.collectionId = builder.collectionId;
        this.expansions = builder.expansions;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String environmentId() {
        return this.environmentId;
    }

    public String collectionId() {
        return this.collectionId;
    }

    public List<Expansion> expansions() {
        return this.expansions;
    }

    public static class Builder {
        private String environmentId;
        private String collectionId;
        private List<Expansion> expansions;

        private Builder(CreateExpansionsOptions createExpansionsOptions) {
            this.environmentId = createExpansionsOptions.environmentId;
            this.collectionId = createExpansionsOptions.collectionId;
            this.expansions = createExpansionsOptions.expansions;
        }

        public Builder() {
        }

        public Builder(String environmentId, String collectionId, List<Expansion> expansions) {
            this.environmentId = environmentId;
            this.collectionId = collectionId;
            this.expansions = expansions;
        }

        public CreateExpansionsOptions build() {
            return new CreateExpansionsOptions(this);
        }

        public Builder addExpansions(Expansion expansions) {
            Validator.notNull((Object)((Object)expansions), (String)"expansions cannot be null");
            if (this.expansions == null) {
                this.expansions = new ArrayList<Expansion>();
            }
            this.expansions.add(expansions);
            return this;
        }

        public Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public Builder expansions(List<Expansion> expansions) {
            this.expansions = expansions;
            return this;
        }

        public Builder expansions(Expansions expansions) {
            this.expansions = expansions.expansions();
            return this;
        }
    }
}

