/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;

public class DeleteTrainingDataOptions
extends GenericModel {
    protected String environmentId;
    protected String collectionId;
    protected String queryId;

    protected DeleteTrainingDataOptions(Builder builder) {
        Validator.notEmpty((String)builder.environmentId, (String)"environmentId cannot be empty");
        Validator.notEmpty((String)builder.collectionId, (String)"collectionId cannot be empty");
        Validator.notEmpty((String)builder.queryId, (String)"queryId cannot be empty");
        this.environmentId = builder.environmentId;
        this.collectionId = builder.collectionId;
        this.queryId = builder.queryId;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String environmentId() {
        return this.environmentId;
    }

    public String collectionId() {
        return this.collectionId;
    }

    public String queryId() {
        return this.queryId;
    }

    public static class Builder {
        private String environmentId;
        private String collectionId;
        private String queryId;

        private Builder(DeleteTrainingDataOptions deleteTrainingDataOptions) {
            this.environmentId = deleteTrainingDataOptions.environmentId;
            this.collectionId = deleteTrainingDataOptions.collectionId;
            this.queryId = deleteTrainingDataOptions.queryId;
        }

        public Builder() {
        }

        public Builder(String environmentId, String collectionId, String queryId) {
            this.environmentId = environmentId;
            this.collectionId = collectionId;
            this.queryId = queryId;
        }

        public DeleteTrainingDataOptions build() {
            return new DeleteTrainingDataOptions(this);
        }

        public Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public Builder queryId(String queryId) {
            this.queryId = queryId;
            return this;
        }
    }
}

