/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v1.model;

import com.google.gson.annotations.SerializedName;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class SourceOptionsWebCrawl
extends GenericModel {
    protected String url;
    @SerializedName(value="limit_to_starting_hosts")
    protected Boolean limitToStartingHosts;
    @SerializedName(value="crawl_speed")
    protected String crawlSpeed;
    @SerializedName(value="allow_untrusted_certificate")
    protected Boolean allowUntrustedCertificate;
    @SerializedName(value="maximum_hops")
    protected Long maximumHops;
    @SerializedName(value="request_timeout")
    protected Long requestTimeout;
    @SerializedName(value="override_robots_txt")
    protected Boolean overrideRobotsTxt;
    protected List<String> blacklist;

    protected SourceOptionsWebCrawl(Builder builder) {
        Validator.notNull((Object)builder.url, (String)"url cannot be null");
        this.url = builder.url;
        this.limitToStartingHosts = builder.limitToStartingHosts;
        this.crawlSpeed = builder.crawlSpeed;
        this.allowUntrustedCertificate = builder.allowUntrustedCertificate;
        this.maximumHops = builder.maximumHops;
        this.requestTimeout = builder.requestTimeout;
        this.overrideRobotsTxt = builder.overrideRobotsTxt;
        this.blacklist = builder.blacklist;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String url() {
        return this.url;
    }

    public Boolean limitToStartingHosts() {
        return this.limitToStartingHosts;
    }

    public String crawlSpeed() {
        return this.crawlSpeed;
    }

    public Boolean allowUntrustedCertificate() {
        return this.allowUntrustedCertificate;
    }

    public Long maximumHops() {
        return this.maximumHops;
    }

    public Long requestTimeout() {
        return this.requestTimeout;
    }

    public Boolean overrideRobotsTxt() {
        return this.overrideRobotsTxt;
    }

    public List<String> blacklist() {
        return this.blacklist;
    }

    public static class Builder {
        private String url;
        private Boolean limitToStartingHosts;
        private String crawlSpeed;
        private Boolean allowUntrustedCertificate;
        private Long maximumHops;
        private Long requestTimeout;
        private Boolean overrideRobotsTxt;
        private List<String> blacklist;

        private Builder(SourceOptionsWebCrawl sourceOptionsWebCrawl) {
            this.url = sourceOptionsWebCrawl.url;
            this.limitToStartingHosts = sourceOptionsWebCrawl.limitToStartingHosts;
            this.crawlSpeed = sourceOptionsWebCrawl.crawlSpeed;
            this.allowUntrustedCertificate = sourceOptionsWebCrawl.allowUntrustedCertificate;
            this.maximumHops = sourceOptionsWebCrawl.maximumHops;
            this.requestTimeout = sourceOptionsWebCrawl.requestTimeout;
            this.overrideRobotsTxt = sourceOptionsWebCrawl.overrideRobotsTxt;
            this.blacklist = sourceOptionsWebCrawl.blacklist;
        }

        public Builder() {
        }

        public Builder(String url) {
            this.url = url;
        }

        public SourceOptionsWebCrawl build() {
            return new SourceOptionsWebCrawl(this);
        }

        public Builder addBlacklist(String blacklist) {
            Validator.notNull((Object)blacklist, (String)"blacklist cannot be null");
            if (this.blacklist == null) {
                this.blacklist = new ArrayList<String>();
            }
            this.blacklist.add(blacklist);
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder limitToStartingHosts(Boolean limitToStartingHosts) {
            this.limitToStartingHosts = limitToStartingHosts;
            return this;
        }

        public Builder crawlSpeed(String crawlSpeed) {
            this.crawlSpeed = crawlSpeed;
            return this;
        }

        public Builder allowUntrustedCertificate(Boolean allowUntrustedCertificate) {
            this.allowUntrustedCertificate = allowUntrustedCertificate;
            return this;
        }

        public Builder maximumHops(long maximumHops) {
            this.maximumHops = maximumHops;
            return this;
        }

        public Builder requestTimeout(long requestTimeout) {
            this.requestTimeout = requestTimeout;
            return this;
        }

        public Builder overrideRobotsTxt(Boolean overrideRobotsTxt) {
            this.overrideRobotsTxt = overrideRobotsTxt;
            return this;
        }

        public Builder blacklist(List<String> blacklist) {
            this.blacklist = blacklist;
            return this;
        }
    }

    public static interface CrawlSpeed {
        public static final String GENTLE = "gentle";
        public static final String NORMAL = "normal";
        public static final String AGGRESSIVE = "aggressive";
    }
}

