/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v1.model;

import com.google.gson.annotations.SerializedName;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class TokenDictRule
extends GenericModel {
    protected String text;
    protected List<String> tokens;
    protected List<String> readings;
    @SerializedName(value="part_of_speech")
    protected String partOfSpeech;

    protected TokenDictRule(Builder builder) {
        Validator.notNull((Object)builder.text, (String)"text cannot be null");
        Validator.notNull((Object)builder.tokens, (String)"tokens cannot be null");
        Validator.notNull((Object)builder.partOfSpeech, (String)"partOfSpeech cannot be null");
        this.text = builder.text;
        this.tokens = builder.tokens;
        this.readings = builder.readings;
        this.partOfSpeech = builder.partOfSpeech;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String text() {
        return this.text;
    }

    public List<String> tokens() {
        return this.tokens;
    }

    public List<String> readings() {
        return this.readings;
    }

    public String partOfSpeech() {
        return this.partOfSpeech;
    }

    public static class Builder {
        private String text;
        private List<String> tokens;
        private List<String> readings;
        private String partOfSpeech;

        private Builder(TokenDictRule tokenDictRule) {
            this.text = tokenDictRule.text;
            this.tokens = tokenDictRule.tokens;
            this.readings = tokenDictRule.readings;
            this.partOfSpeech = tokenDictRule.partOfSpeech;
        }

        public Builder() {
        }

        public Builder(String text, List<String> tokens, String partOfSpeech) {
            this.text = text;
            this.tokens = tokens;
            this.partOfSpeech = partOfSpeech;
        }

        public TokenDictRule build() {
            return new TokenDictRule(this);
        }

        public Builder addTokens(String tokens) {
            Validator.notNull((Object)tokens, (String)"tokens cannot be null");
            if (this.tokens == null) {
                this.tokens = new ArrayList<String>();
            }
            this.tokens.add(tokens);
            return this;
        }

        public Builder addReadings(String readings) {
            Validator.notNull((Object)readings, (String)"readings cannot be null");
            if (this.readings == null) {
                this.readings = new ArrayList<String>();
            }
            this.readings.add(readings);
            return this;
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder tokens(List<String> tokens) {
            this.tokens = tokens;
            return this;
        }

        public Builder readings(List<String> readings) {
            this.readings = readings;
            return this;
        }

        public Builder partOfSpeech(String partOfSpeech) {
            this.partOfSpeech = partOfSpeech;
            return this;
        }
    }
}

